% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_matrix.R
\name{ldscore}
\alias{ldscore}
\title{Compute LD (Linkage Disequilibrium) Scores for a Given Chromosome.}
\usage{
ldscore(
  Glist = NULL,
  chr = NULL,
  onebased = TRUE,
  nbytes = 4,
  cm = NULL,
  kb = NULL
)
}
\arguments{
\item{Glist}{A list structure with genotypic data stored, including positions (`pos`), map information (`map`), rsids for LD calculation (`rsidsLD`), and LD file locations (`ldfiles`).}

\item{chr}{A single chromosome or a vector of chromosomes for which LD scores need to be computed. Default is NULL, implying all chromosomes in `Glist` will be used.}

\item{onebased}{Logical, if `TRUE`, the indexing of positions and other genomic information is 1-based. Default is `TRUE`.}

\item{nbytes}{The size (in bytes) of each numeric value to read from the binary LD files. Default is 4.}

\item{cm}{The threshold in centiMorgans for filtering LD values. Default is NULL.}

\item{kb}{The threshold in kilobases for filtering LD values. Default is NULL. If specified, it will be converted to base pairs internally.}
}
\value{
A list containing computed LD scores for each chromosome in the input.
}
\description{
This function calculates LD scores for the specified chromosome(s) based on genotypic data provided in `Glist`.
The LD score quantifies the amount of Linkage Disequilibrium at a given SNP.
}
\details{
The function computes the LD scores for each SNP by reading LD values from binary files stored in `Glist$ldfiles`.
It can filter SNPs based on physical distance (`kb`) or genetic map distance (`cm`). 
If both `cm` and `kb` are NULL, all LD values are used in computation.
}
\keyword{internal}
