% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_qfrm.R
\name{print.qfrm}
\alias{print.qfrm}
\alias{print.qfpm}
\alias{plot.qfrm}
\alias{methods.qfrm}
\title{Methods for qfrm and qfpm objects}
\usage{
\method{print}{qfrm}(
  x,
  digits = getOption("digits"),
  show_range = !is.null(x$error_bound),
  ...
)

\method{print}{qfpm}(x, digits = getOption("digits"), ...)

\method{plot}{qfrm}(
  x,
  add_error = length(x$seq_error) > 0,
  add_legend = add_error,
  ylim = x$statistic * ylim_f,
  ylim_f = c(0.9, 1.1),
  xlab = "Order of evaluation",
  ylab = "Moment of ratio",
  col_m = "royalblue4",
  col_e = "tomato",
  lwd_m = 1,
  lwd_e = 1,
  lty_m = 1,
  lty_e = 2,
  pos_leg = "topright",
  ...
)
}
\arguments{
\item{x}{\code{qfrm} or \code{qfpm} object}

\item{digits}{Number of significant digits to be printed.}

\item{show_range}{Logical to specify whether the possible range for the moment
is printed (when available).  Default \code{TRUE} when available.}

\item{...}{In the \code{plot} methods, passed to
\code{\link[graphics]{plot.default}}.  In the \code{print} methods,
ignored (retained for the compatibility with the generic method).}

\item{add_error}{Logical to specify whether the sequence of error bounds is plotted
(when available).  Default \code{TRUE} when available.}

\item{add_legend}{Logical to specify whether a legend is added.  Turned on by default
when \code{add_error = TRUE}.}

\item{ylim, ylim_f}{\code{ylim} is passed to \code{\link[graphics]{plot.default}}.  By default,
this is automatically set to \code{ylim_f} times the terminal value of
the series expression (\code{x$statistic}).  \code{ylim_f} is
by default \code{c(0.9, 1.1)}.}

\item{xlab, ylab}{Passed to \code{\link[graphics]{plot.default}}}

\item{col_m, col_e, lwd_m, lwd_e, lty_m, lty_e}{\code{col}, \code{lwd}, and \code{lty} to plot the sequences of
the moment (\code{***_m}) and its error bound (\code{***_e})}

\item{pos_leg}{Position of the legend, e.g., \code{"topright"}, \code{"bottomright"},
passed as the first argument for \code{\link[graphics]{legend}}}
}
\value{
The \code{print} method invisibly returns the input.

The \code{plot} method is used for the side effect (and invisibly returns
\code{NULL}).
}
\description{
Straightforward \code{print} and \code{plot} methods are defined
for \code{qfrm} and \code{qfpm} objects which result from the
\code{\link{qfrm}}, \code{\link{qfmrm}}, and \code{\link{qfpm}} functions.
}
\details{
The \code{print} methods simply display the moment \code{x$statistic}
(typically a partial sum), its error bound \code{x$error_bound}
(when available), and the possible range of the moment
(\code{x$statistic} to \code{x$statistic + x$error_bound} in case of
one-sided error bound; \code{x$statistic - x$error_bound} to
\code{x$statistic + x$error_bound} in case of two-sided).

The \code{plot} method is designed for quick inspection of the profile of
the partial sum of the series along varying orders
\code{cumsum(x$terms)}.  When the object has a sequence for error bounds
\code{x$seq_error}, this is also shown with a broken line (by default).  When
the object has an exact moment (i.e., resulting from
\code{\link{qfrm_ApIq_int}()} or the \code{\link{qfpm}} functions), a message
is thrown to tell inspection of the plot will not be required in this case.
}
\examples{
nv <- 4
A <- diag(nv:1)
B <- diag(1:nv)
mu <- rep.int(1, nv)

res1 <- qfrm(A, B, p = 3, mu = mu)
print(res1)
print(res1, digits = 5)
print(res1, digits = 10)

## Default plot: ylim too narrow to see the error bound at this m
plot(res1)

## With extended ylim
plot(res1, ylim_f = c(0.8, 1.2), pos_leg = "topleft")

## In this case, it is easy to increase m
(res2 <- qfrm(A, B, p = 3, mu = mu, m = 200))
plot(res2)

}
\seealso{
\code{\link{new_qfrm}}: descriptions of the classes and their
\dQuote{constructors}
}
