% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa3.1.R
\name{qfa.plot}
\alias{qfa.plot}
\title{Quantile-Frequency Plot}
\usage{
qfa.plot(
  freq,
  tau,
  rqper,
  rg.qper = range(rqper),
  rg.tau = range(tau),
  rg.freq = c(0, 0.5),
  color = colorRamps::matlab.like2(1024),
  ylab = "QUANTILE LEVEL",
  xlab = "FREQUENCY",
  tlab = NULL,
  set.par = TRUE,
  legend.plot = TRUE
)
}
\arguments{
\item{freq}{sequence of frequencies in (0,0.5) at which quantile spectrum is evaluated}

\item{tau}{sequence of quantile levels in (0,1) at which quantile spectrum is evaluated}

\item{rqper}{real-valued matrix of quantile spectrum evaluated on the \code{freq} x \code{tau} grid}

\item{rg.qper}{\code{zlim} for \code{qper} (default = \code{range(qper)})}

\item{rg.tau}{\code{ylim} for \code{tau} (default = \code{range(tau)})}

\item{rg.freq}{\code{xlim} for \code{freq} (default = \code{c(0,0.5)})}

\item{color}{colors (default = \code{colorRamps::matlab.like2(1024)})}

\item{ylab}{label of y-axis (default = \code{"QUANTILE LEVEL"})}

\item{xlab}{label of x-axis (default = \code{"FREQUENCY"})}

\item{tlab}{title of plot (default = \code{NULL})}

\item{set.par}{if \code{TRUE}, \code{par()} is set internally (single image)}

\item{legend.plot}{if \code{TRUE}, legend plot is added}
}
\value{
no return value
}
\description{
This function creates an image plot of quantile spectrum.
}
