% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case.R
\name{TC}
\alias{TC}
\alias{L}
\alias{U}
\title{Upper/Lower/Title Case}
\usage{
TC(text.var, lower = NULL, ...)

L(text.var, ...)

U(text.var, ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{lower}{A vector of words to retain lower case for (unless first or last word).}

\item{\ldots}{Other arguments passed to: \code{\link[stringi]{stri_trans_tolower}},
\code{\link[stringi]{stri_trans_toupper}}, and \code{\link[stringi]{stri_trans_totitle}}.}
}
\value{
Returns a character vector with new case (lower, upper, or title).
}
\description{
\code{TC} - Capitalize titles according to traditional capitalization rules.

\code{L} - All lower case.

\code{U} - All upper case.
}
\details{
Case wrapper functions for \pkg{stringi}'s \code{\link[stringi]{stri_trans_tolower}},
\code{\link[stringi]{stri_trans_toupper}}, and \code{\link[stringi]{stri_trans_totitle}}.
Functions are useful within \pkg{magrittr} style chaining.
}
\note{
\code{TC} utilizes additional rules for capitalization beyond 
\code{\link[stringi]{stri_trans_totitle}} that include:
\enumerate{
  \item Capitalize the first & last word
  \item Lowercase articles, coordinating conjunctions, & prepositions
  \item Lowercase "to" in an infinitive
  }
}
\examples{
y <- c(
   "I'm liking it but not too much.", 
   "How much are you into it?",  
   "I'd say it's yet awesome yet."
) 
L(y)
U(y)
TC(y)
}
\seealso{
\code{\link[stringi]{stri_trans_tolower}},
\code{\link[stringi]{stri_trans_toupper}},
\code{\link[stringi]{stri_trans_totitle}}
}
