% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bind_or.R
\name{bind_or}
\alias{bind_or}
\title{Boundary Wrap (Bind) and `or` Concatenate Elements}
\usage{
bind_or(..., group.all = TRUE, left = "\\\\b", right = left)
}
\arguments{
\item{group.all}{logical.  If \code{TRUE} the resulting `or` concatenated
elements will be wrapped with grouping parenthesis.}

\item{left}{A single length character vector to use as the left bound.}

\item{right}{A single length character vector to use as the right bound.}

\item{\ldots}{Regular expressions to paste together or a named expression
from the default regular expression dictionary prefixed with single at
(\code{@}) (e.g., \code{"@rm_hash"}) or a regular expression from
\code{\link[qdapRegex]{regex_supplement}} dictionary prefixed with an at
(\code{@}) (e.g., \code{"@time_12_hours"}).}
}
\description{
A wrapper for \code{bind} and \code{pastex} that wraps each sub-expression
element with left/right boundaries (\code{\\b} by default) and then
concatenate/joins bound strings with a regex `or` ("|").  Equivalent to
\code{pastex(bind(...), sep = "|")}.
}
\examples{
bind_or(LETTERS)
bind_or("them", "those", "that", "these")
bind_or("them", "those", "that", "these", group.all = FALSE)
}

