% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qch_test.R
\name{qch.test}
\alias{qch.test}
\title{Perform composite hypothesis testing.}
\usage{
qch.test(res.qch.fit, Hconfig, Hconfig.H1 = NULL, Alpha = 0.05, threads_nb = 0)
}
\arguments{
\item{res.qch.fit}{The result provided by the \code{\link[=qch.fit]{qch.fit()}} function.}

\item{Hconfig}{A list of all possible combination of \eqn{H_0} and \eqn{H_1} hypotheses generated by the \code{\link[=GetHconfig]{GetHconfig()}} function.}

\item{Hconfig.H1}{An integer vector (or a list of such vector) of the \code{Hconfig} index corresponding to the composite alternative hypothesis configuration(s).
Can be generated by the \code{\link[=GetH1AtLeast]{GetH1AtLeast()}} or \code{\link[=GetH1Equal]{GetH1Equal()}} functions.
If \code{NULL}, the composite hyporhesis tests of being associated with "at least \eqn{q}" simple tests, for q=1,..Q are performed.}

\item{Alpha}{the nominal Type I error rate for FDR control. Default is \code{0.05}.}

\item{threads_nb}{The number of threads to use. The number of thread will set to the number of core available by default.}
}
\value{
A list with the following elements:
\tabular{ll}{
\code{Rejection} \tab a matrix providing for each item the result of the composite hypothesis test,
after adaptive Benjamin-Höchberg multiple testing correction.\cr
\code{lFDR} \tab a matrix providing for each item its local FDR estimate.\cr
\code{Pvalues} \tab a matrix providing for each item its p-value of the composite hypothesis test.
}
}
\description{
Perform any composite hypothesis test by specifying
the configurations '\code{Hconfig.H1}' corresponding to the composite alternative hypothesis
among all configurations '\code{Hconfig}'.

By default, the function performs the composite hypothesis test of being associated with "at least \eqn{q}" simple tests, for \eqn{q=1,..Q}.
}
\examples{
data(PvalSets_cor)
PvalMat <- as.matrix(PvalSets_cor[,-3])
Truth <- PvalSets[,3]

## Build the Hconfig objects
Q <- 2
Hconfig <- GetHconfig(Q)

## Infer the posteriors
res.fit <- qch.fit(pValMat = PvalMat, Hconfig = Hconfig, copula="gaussian")

## Run the test procedure with FDR control
H1config <- GetH1AtLeast(Hconfig,2)
res.test <- qch.test(res.qch.fit = res.fit,Hconfig = Hconfig, Hconfig.H1 = H1config)
table(res.test$Rejection$AtLeast_2,Truth==4)


}
\seealso{
\code{\link[=qch.fit]{qch.fit()}}, \code{\link[=GetH1AtLeast]{GetH1AtLeast()}},\code{\link[=GetH1Equal]{GetH1Equal()}}
}
