% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QCH_functions.R
\name{qch.test}
\alias{qch.test}
\title{Perform composed hypothesis testing with FDR control}
\usage{
qch.test(posterior, Hconfig.H1, Alpha = 0.05)
}
\arguments{
\item{posterior}{a matrix of posterior probabilities for each item to belong the different H-configurations, as provided by the \code{\link[=qch.fit]{qch.fit()}} function.}

\item{Hconfig.H1}{a list of H1 config, as created by the \code{\link[=GetHinfo]{GetHinfo()}} function.}

\item{Alpha}{the nominal Type I error rate for FDR control.}
}
\value{
A list of 2 objects 'Rejection' and 'lFDR'.
Object 'Rejection' is a vector providing for each item the result of the composed hypothesis test, after multiple testing correction.
Object 'lFDR' is a vector providing for each item its local FDR estimate.
}
\description{
Perform composed hypothesis testing with FDR control
}
\examples{
data(PvalSets)
PvalMat <- as.matrix(PvalSets[,-3])
Truth <- PvalSets[,3]

## Build the Hconfig objects
Q <- 2
AtLeast <- 2
Hconfig <- GetHinfo(Q,AtLeast)$Hconfig
Hconfig.H1 <- GetHinfo(Q,AtLeast)$Hconfig.H1

## Infer the posteriors
res.fit <- qch.fit(PvalMat,Hconfig)

## Run the test procedure with FDR control
res.test <- qch.test(res.fit$posterior,Hconfig.H1)
table(res.test$Rejection,Truth==4)
}
