% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_extras.R
\name{summarize_app}
\alias{summarize_app}
\title{Summarize an app}
\usage{
summarize_app(subdomain, auth, app_id, agent = NULL)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{app_id}{Character vector with one element. Unique identifier of an app.
Found in the URL of the app's homepage after /db/}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}
}
\value{
A list of tibbles.
}
\description{
Get metadata for an app, its tables, and its fields.
}
\examples{
\dontrun{
   summarize_app(subdomain = "abc",
                 auth = keyring::key_get("qb_example"),
                 app_id = "bsf5hphe5")
}
}
