% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_density}
\alias{plot_density}
\title{Plot density of empirical checkerboard copula}
\usage{
plot_density(mass_matrix, density = TRUE)
}
\arguments{
\item{mass_matrix}{a squared matrix containing the mass distribution, e.g. output of the function \code{emp_c_copula()}.}

\item{density}{a logical (TRUE = default) whether the density or the mass is plotted.}
}
\value{
a density plot (or mass distribution)
}
\description{
Plots the density/mass of the empirical checkerboard copula.
}
\examples{
n <- 1000
x <- runif(n,0,1)
y <- runif(n,0,1)
sample <- data.frame(x,y)
plot(sample)

mass <- emp_c_copula(sample, resolution=8)
plot_density(mass, density=TRUE)
plot_density(mass, density=FALSE)
}
