% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_iso.R
\name{redist_iso}
\alias{redist_iso}
\title{Data redistribution to country subdivisions}
\usage{
redist_iso(
  data,
  iso_col,
  values_col,
  redist_data,
  redist_iso_col,
  redist_values_col
)
}
\arguments{
\item{data}{A data frame containing the data at the country-level to
redistribute.}

\item{iso_col}{A string specifying the column name in \code{data}
with the ISO 3166-1 (alpha-2) country codes.}

\item{values_col}{A string or vector specifying the column name(s) in
\code{data} with the values to be redistributed.}

\item{redist_data}{A data frame with values for each subdivision that will be
used as the basis for redistribution.}

\item{redist_iso_col}{A string specifying the column name in \code{redist_data}
that contains the destination ISO 3166-2 codes.}

\item{redist_values_col}{A string specifying the column name in \code{redist_data}
with the values for proportional redistribution. This will define the weights
used for the redistribution.}
}
\value{
A data frame with the redistributed values across the specified subnational
level. The data frame contains the columns \code{ISO_1} with the codes at country
level, \code{ISO_2} with the codes at subdivision level, \code{proportion} with the
proportion according to which the values have been redistributed, and the columns
corresponding to the redistributed values with the same name specified in \code{values_col}.
}
\description{
Value redistribution from country-level (i.e., ISO 3166-1 alpha-2 codes) to principal
subdivisions (i.e., ISO 3166-2 codes). See
\href{https://www.iso.org/iso-3166-country-codes.html}{ISO 3166 Maintenance Agency}.
}
\details{
This function enables redistribution of values from country-level
to principal subdivisions (e.g., provinces or states), proportionally
to user-supplied redistribution proportions.

Note that more than one column of values provided in the data frame data can be
redistributed at the same time. The values in columns \code{values_col} and
\code{redist_values_col} must be numeric and positive.
\subsection{Common uses}{

In the context of quantitative pest risk assessment (qPRA) at the entry step,
this function can be applied to redistribute the quantity of potentially infested
commodities (\eqn{N_{trade}}, see \code{\link[=ntrade]{ntrade()}}) or the number of potential
founder populations (\eqn{NPFP}, see \code{\link[=pathway_model]{pathway_model()}}). For this purpose,
human population or consumption data from subdivisions are often used for redistribution.
}
}
\examples{
## Example of data redistribution in Northern American countries
data(datatrade_NorthAm)
# Selection of internal production data from January to March to be proportionally 
# redistributed based on sub-national consumption data
data_ip <- datatrade_NorthAm$internal_production
data_ip <- data_ip[data_ip$time_period=="January-March",]
# consumption data at sub-national level
data_sub <- datatrade_NorthAm$consumption_iso2

# Redistribution
data_redist <- redist_iso(data = data_ip,
                          iso_col = "reporter",
                          values_col = "value",
                          redist_data = data_sub,
                          redist_iso_col = "iso_3166_2",
                          redist_values_col = "value")

head(data_redist)

}
\seealso{
\code{\link[=ntrade]{ntrade()}}, \code{\link[=pathway_model]{pathway_model()}}
}
