% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_variable2.R
\name{px_domain}
\alias{px_domain}
\alias{px_domain.px}
\title{DOMAIN}
\usage{
px_domain(x, value, validate)

\method{px_domain}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A character string or data frame.
\itemize{
\item Use character to set DOMAIN for all languages and STUB/HEADING
variables.
\item Use data frame with columns 'variable-code', 'language' and
'domain' to set DOMAIN for specific variables.
\item If missing, the current DOMAIN is returned.
\item If NULL, DOMAIN is removed for all variables.
}}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object, a character string, or a data frame.
}
\description{
Inspect or change DOMAIN.
}
\examples{
# Set DOMAIN for all languages
x1 <-
  px(population_gl) |>
  px_domain('aggregation1')

# Print DOMAIN
px_domain(x1)

# Set DOMAIN for individual variables
library(tibble)
x2 <-
  x1 |>
  px_domain(tribble(~`variable-code`, ~domain,
                    'gender', 'aggregation2',
                    'age',    'aggregation3'))
px_domain(x2)

# Set DOMAIN for individual languages
x3 <-
  x2 \%>\%
  px_languages(c('en', 'kl')) |>
  px_domain(tribble(~`variable-code`, ~language, ~domain,
                    'gender',    'en',      'aggregation2_en',
                    'gender',    'kl',      'aggregation2_kl',
                    'age',       'en',      'aggregation3_en'))
px_domain(x3)

# Remove DOMAIN
x4 <- px_domain(x3, NULL)
px_domain(x4)
}
\seealso{
\href{https://www.scb.se/globalassets/vara-tjanster/px-programmen/px-file_format_specification_2013.pdf#\%5B\%7B\%22num\%22\%3A45\%2C\%22gen\%22\%3A0\%7D\%2C\%7B\%22name\%22\%3A\%22XYZ\%22\%7D\%2C184\%2C214\%2C0\%5D}{Statistics Sweden's documentation}
}
