% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indcorr.R
\name{indcorr}
\alias{indcorr}
\title{Compute Power for Comparing Two Independent Correlations
Takes correlations and range of values}
\usage{
indcorr(r1, r2, nlow, nhigh, propn1 = 0.5, alpha = 0.05, tails = 2,
  by = 1)
}
\arguments{
\item{r1}{Correlation for Group 1}

\item{r2}{Correlation for Group 2}

\item{nlow}{Starting sample size}

\item{nhigh}{Ending sample size}

\item{propn1}{Proportion of sample in first group (default is .50 for equally size groups)}

\item{alpha}{Type I error (default is .05)}

\item{tails}{one or two-tailed tests (default is 2)}

\item{by}{Incremental increase in sample size from low to high}
}
\value{
Power for Comparing Two Independent Correlations
}
\description{
Compute Power for Comparing Two Independent Correlations
Takes correlations and range of values
}
\examples{
indcorr(r1=.3,r2=.1,nlow=200,nhigh=800,by=50, tails=1)
}
