% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-lift.R
\name{lift}
\alias{lift}
\alias{lift_dl}
\alias{lift_dv}
\alias{lift_vl}
\alias{lift_vd}
\alias{lift_ld}
\alias{lift_lv}
\title{Lift the domain of a function}
\usage{
lift(..f, ..., .unnamed = FALSE)

lift_dl(..f, ..., .unnamed = FALSE)

lift_dv(..f, ..., .unnamed = FALSE)

lift_vl(..f, ..., .type)

lift_vd(..f, ..., .type)

lift_ld(..f, ...)

lift_lv(..f, ...)
}
\arguments{
\item{..f}{A function to lift.}

\item{...}{Default arguments for \code{..f}. These will be
evaluated only once, when the lifting factory is called.}

\item{.unnamed}{If \code{TRUE}, \code{ld} or \code{lv} will not
name the parameters in the lifted function signature. This
prevents matching of arguments by name and match by position
instead.}

\item{.type}{Can be a vector mold specifying both the type and the
length of the vectors to be concatenated, such as \code{numeric(1)}
or \code{integer(4)}. Alternatively, it can be a string describing
the type, one of: "logical", "integer", "double", "complex",
"character" or "raw".}
}
\value{
A function.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

\code{lift_xy()} is a composition helper. It helps you compose
functions by lifting their domain from a kind of input to another
kind. The domain can be changed from and to a list (l), a vector
(v) and dots (d). For example, \code{lift_ld(fun)} transforms a
function taking a list to a function taking dots.

The most important of those helpers is probably \code{lift_dl()}
because it allows you to transform a regular function to one that
takes a list. This is often essential for composition with purrr
functional tools. Since this is such a common function,
\code{lift()} is provided as an alias for that operation.

These functions were superseded in purrr 1.0.0 because we no longer believe
"lifting" to be a mainstream operation, and we are striving to reduce purrr
to its most useful core. Superseded functions will not go away, but will only
receive critical bug fixes.
}
\section{from ... to \code{list(...)} or \code{c(...)}}{

Here dots should be taken here in a figurative way. The lifted
functions does not need to take dots per se. The function is
simply wrapped a function in \code{\link[=do.call]{do.call()}}, so instead
of taking multiple arguments, it takes a single named list or
vector which will be interpreted as its arguments.  This is
particularly useful when you want to pass a row of a data frame
or a list to a function and don't want to manually pull it apart
in your function.
}

\section{from \code{c(...)} to \code{list(...)} or \code{...}}{

These factories allow a function taking a vector to take a list
or dots instead. The lifted function internally transforms its
inputs back to an atomic vector. purrr does not obey the usual R
casting rules (e.g., \code{c(1, "2")} produces a character
vector) and will produce an error if the types are not
compatible. Additionally, you can enforce a particular vector
type by supplying \code{.type}.
}

\section{from list(...) to c(...) or ...}{

\code{lift_ld()} turns a function that takes a list into a
function that takes dots. \code{lift_vd()} does the same with a
function that takes an atomic vector. These factory functions are
the inverse operations of \code{lift_dl()} and \code{lift_dv()}.

\code{lift_vd()} internally coerces the inputs of \code{..f} to
an atomic vector. The details of this coercion can be controlled
with \code{.type}.
}

\examples{
### Lifting from ... to list(...) or c(...)

x <- list(x = c(1:100, NA, 1000), na.rm = TRUE, trim = 0.9)
lift_dl(mean)(x)
# You can also use the lift() alias for this common operation:
lift(mean)(x)
# now:
exec(mean, !!!x)

# Default arguments can also be specified directly in lift_dl()
list(c(1:100, NA, 1000)) |> lift_dl(mean, na.rm = TRUE)()
# now:
mean(c(1:100, NA, 1000), na.rm = TRUE)

# lift_dl() and lift_ld() are inverse of each other.
# Here we transform sum() so that it takes a list
fun <- sum |> lift_dl()
fun(list(3, NA, 4, na.rm = TRUE))
# now:
fun <- function(x) exec("sum", !!!x)
exec(sum, 3, NA, 4, na.rm = TRUE)
### Lifting from c(...) to list(...) or ...

# In other situations we need the vector-valued function to take a
# variable number of arguments as with pmap(). This is a job for
# lift_vd():
pmap_dbl(mtcars, lift_vd(mean))
# now
pmap_dbl(mtcars, \(...) mean(c(...)))
### Lifting from list(...) to c(...) or ...

# This kind of lifting is sometimes needed for function
# composition. An example would be to use pmap() with a function
# that takes a list. In the following, we use some() on each row of
# a data frame to check they each contain at least one element
# satisfying a condition:
mtcars |> pmap_lgl(lift_ld(some, partial(`<`, 200)))
# now
mtcars |> pmap_lgl(\(...) any(c(...) > 200))

}
\seealso{
\code{\link[=invoke]{invoke()}}
}
\keyword{internal}
