% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_functions.R
\name{mhor}
\alias{mhor}
\title{Mantel-Haenszel odds ratio.}
\usage{
mhor(object = NULL, formula = NULL, data = NULL)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions of the chain. Most users can safely ignore this argument. See details and examples.}

\item{formula}{A formula with shape: outcome ~ stratum/exposure.}

\item{data}{A data frame containing the variables used in \code{formula}.}
}
\value{
Odds ratios with 95% confidence intervals on the effect of \code{exposure} on
  \code{outcome} by levels of \code{stratum}. The Mantel-Haenszel pooled OR and the test
  for effect modification is also reported.
}
\description{
\code{mhor} computes odds ratios by levels of the stratum variable as well as the Mantel-Haenszel
pooled odds ratio. The test for effect modification (test for interaction) is also displayed.
}
\examples{
data(oswego, package = "epitools")
require(dplyr, quietly = TRUE)
require(sjlabelled, quietly = TRUE)
oswego <- oswego \%>\%
  mutate(
    ill = factor(ill, labels = c("No", "Yes")),
    sex = factor(sex, labels = c("Female", "Male")),
    chocolate.ice.cream = factor(chocolate.ice.cream, labels = c("No", "Yes"))
  ) \%>\%
  var_labels(
    ill = "Developed illness",
    sex = "Sex",
    chocolate.ice.cream = "Consumed chocolate ice cream"
  )

require(moonBook, quietly = TRUE)
mytable(ill ~ sex + chocolate.ice.cream, data = oswego, show.total = TRUE)

oswego \%>\%
  mhor(ill ~ sex/chocolate.ice.cream)
}
\seealso{
\link{mh}
}
