% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_file_ops.R
\name{seq_file_ops}
\alias{seq_file_ops}
\title{seq_file_ops}
\usage{
seq_file_ops(n, target_dir = NULL, filetype = "R", force = FALSE)
}
\arguments{
\item{n}{The number of files to create. Also accepts numerical vector.}

\item{target_dir}{Directory to create files. Creates the directory if
file.exists(target_dir) evaluates to FALSE.}

\item{filetype}{The suffix to append the filename. Defaults to ".R".}

\item{force}{Defaults to FALSE. If set to TRUE, seq_file_ops will
overwrite any pre-existing files that match the write filenames asked for.}
}
\value{
Write a series of sequentially numbered files within a specified
directory. Creates the directory if required.
}
\description{
Quickly create the required number of sequentially labelled files.
}
\examples{

\dontshow{.old_wd <- setwd(tempdir())}

seq_file_ops(n = 10, target_dir = "munge")

seq_file_ops(n = c(1, 3:8, 10), target_dir = "complex_vector")

# if force == FALSE, pre-existing numbered scripts will not be overwritten
# only 02-.R and 09-.R are written below
seq_file_ops(10, target_dir = "complex_vector")

unlink("munge", recursive = TRUE)
unlink("complex_vector", recursive = TRUE)

\dontshow{setwd(.old_wd)}

}
