% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wt_stat.R
\name{wt_cov}
\alias{wt_cov}
\alias{wt_cor}
\title{Compute weighted covariances}
\usage{
wt_cov(x, y = NULL, wt = NULL, as_cor = FALSE, use = "everything")

wt_cor(x, y = NULL, wt = NULL, use = "everything")
}
\arguments{
\item{x}{Vector or matrix of x variables.}

\item{y}{Vector or matrix of y variables}

\item{wt}{Vector of weights}

\item{as_cor}{Logical scalar that determines whether the covariances should be standardized (TRUE) or unstandardized (FALSE).}

\item{use}{Method for handling missing values. "everything" uses all values and does not account for missingness, "listwise" uses only complete cases, and "pairwise" uses pairwise deletion.}
}
\value{
Scalar, vector, or matrix of covariances.
}
\description{
Compute the weighted covariance among variables in a matrix or between the variables in two separate matrices/vectors.
}
\examples{
wt_cov(x = c(1, 0, 2), y = c(1, 2, 3), wt = c(1, 2, 2), as_cor = FALSE, use = "everything")
wt_cov(x = c(1, 0, 2), y = c(1, 2, 3), wt = c(1, 2, 2), as_cor = TRUE, use = "everything")
}
