% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/center_group_mean.R
\name{center_group_mean}
\alias{center_group_mean}
\title{Center with respect to group mean}
\usage{
center_group_mean(data, cols, group, keep_original = TRUE)
}
\arguments{
\item{data}{A data.frame or a data.frame extension (e.g. a tibble).}

\item{cols}{Columns that need to be centered. See `dplyr::dplyr_tidy_select` for available options.}

\item{group}{character. grouping variable}

\item{keep_original}{default is `TRUE`. Set to `FALSE` to remove original columns}
}
\value{
An object of the same type as .data. The output has the following properties:  
1. Columns from .data will be preserved
2. Columns with scores that are group-mean centered
}
\description{
This function will compute group-mean-centered scores.
}
\examples{
center_group_mean(iris,where(is.numeric), group = Species)

}
