% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TE,CV,SEM.R
\name{SEM}
\alias{SEM}
\title{Standard Error of Measurement (SEM) for a set of athlete measurements}
\usage{
SEM(subject, trial, ..., ICC)
}
\arguments{
\item{subject}{The vector of athletes who recorded the results for each metric (can be a numeric or factor variable)}

\item{trial}{The vector that represents which trial each measurement came from}

\item{...}{Numeric vectors that represent the metrics for which the SEM should be computed. These vectors hold the scores that
each athlete recorded for each respective metric (at least one metric must be passed to the function).}

\item{ICC}{A vector of the ICC's for each of the metrics included in the "..." argument. This vector must contain the same
number of elements as the number of metrics that have been passed to the function in the "..." argument, and the reliability
values must appear in the same order as the metrics appear in the "..." argument.}
}
\value{
A data frame, with the name of each metric situated above its calculated SEM
}
\description{
Computes the SEM for each metric that is passed to the function as a vector of measurements, for the subject and
  trial vectors and the ICC's of the metrics
}
\examples{
subject <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
trial <- c(1, 2, 3, 1, 2, 3, 1, 2, 3)
metric_1 <- c(250, 258, 252, 279, 270, 277, 218, 213, 218)
metric_2 <- c(10, 7, 10, 14, 18, 17, 11, 7, 8)
metric_3 <- c(1214, 1276, 1289, 1037, 1010, 1069, 1481, 1465, 1443)
SEM(subject, trial, metric_1, metric_2, metric_3, ICC = c(0.92, 0.98, 0.95))

}
\references{
Atkinson, G., & Nevill, A. M. (1998). Statistical Methods For Assessing Measurement Error (Reliability) in Variables
  Relevant to Sports Medicine. Sports Medicine, 26(4), 217-238.
}
