# PRQL query

    Code
      cat(prql_compile("from a | select {b}"))
    Output
      SELECT
        b
      FROM
        a
      
      -- Generated by PRQL compiler version:0.9.5 (https://prql-lang.org)

---

    Code
      cat(prql_compile("from a | select {b}", NA, FALSE, FALSE))
    Output
      SELECT b FROM a

---

    Code
      cat(unwrap(compile(
        "from star_wars\n    select {star_wars.*}\n    select !{jar_jar_binks, midichlorians}",
        "sql.duckdb")))
    Output
      SELECT
        * EXCLUDE (jar_jar_binks, midichlorians)
      FROM
        star_wars
      
      -- Generated by PRQL compiler version:0.9.5 target:sql.duckdb (https://prql-lang.org)

# Syntax error query=Mississippi has four S’s and four I’s.

    Code
      cat(prql_compile(query, "sql.any", TRUE, FALSE))
    Error <simpleError>
      Error:
         ╭─[:1:23]
         │
       1 │ Mississippi has four S’s and four I’s.
         │                       ┬
         │                       ╰── unexpected ’
      ───╯
      Error:
         ╭─[:1:36]
         │
       1 │ Mississippi has four S’s and four I’s.
         │                                    ┬
         │                                    ╰── unexpected ’
      ───╯
      Error:
         ╭─[:1:38]
         │
       1 │ Mississippi has four S’s and four I’s.
         │                                      ┬
         │                                      ╰── Expected * or an identifier, but didn't find anything before the end.
      ───╯

# Syntax error query=from a | select [b]

    Code
      cat(prql_compile(query, "sql.any", TRUE, FALSE))
    Error <simpleError>
      Error:
         ╭─[:1:17]
         │
       1 │ from a | select [b]
         │                 ─┬─
         │                  ╰─── unexpected `[this.a.b]`
         │
         │ Help: this is probably a 'bad type' error (we are working on that)
      ───╯

# Syntax error query=from a | select {{{b

    Code
      cat(prql_compile(query, "sql.any", TRUE, FALSE))
    Error <simpleError>
      Error:
         ╭─[:1:20]
         │
       1 │ from a | select {{{b
         │                    ┬
         │                    ╰── unexpected end of input while parsing function call
      ───╯

# Targets target=sql.any

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200 AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.ansi

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200 AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.bigquery

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200 AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.clickhouse

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200 AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.duckdb

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200 AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.generic

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200 AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.mssql

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        TOP (2) origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200 AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay

# Targets target=sql.mysql

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200 AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.postgres

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND((AVG(arr_delay)) :: numeric, 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200 AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.sqlite

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200 AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

# Targets target=sql.snowflake

    Code
      cat(prql_compile(query, target, TRUE, FALSE))
    Output
      SELECT
        origin,
        dest,
        COUNT(*) AS num_flts,
        ROUND(AVG(arr_delay), 0) AS avg_delay
      FROM
        flights
      WHERE
        distance BETWEEN 200 AND 300
        AND air_time IS NOT NULL
      GROUP BY
        origin,
        dest
      ORDER BY
        origin DESC,
        avg_delay
      LIMIT
        2

