% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indscal.R
\name{indscal}
\alias{indscal}
\title{Individual Differences Scaling of provenance data}
\usage{
indscal(..., type = "ordinal")
}
\arguments{
\item{...}{a sequence of datasets of class \code{distributional} or
\code{compositional}}

\item{type}{is either "ratio" or "ordinal"}
}
\value{
an object of class \code{INDSCAL}, i.e. a list containing
the following items:

\code{delta}: Observed dissimilarities

\code{obsdiss}: List of observed dissimilarities, normalized

\code{confdiss}: List of configuration dissimilarities

\code{conf}: List of matrices of final configurations

\code{gspace}: Joint configurations aka group stimulus space

\code{cweights}: Configuration weights

\code{stress}: Stress-1 value

\code{spp}: Stress per point

\code{sps}: Stress per subject (matrix)

\code{ndim}: Number of dimensions

\code{model}: Type of smacof model

\code{niter}: Number of iterations

\code{nobj}: Number of objects
}
\description{
Performs 3-way Multidimensional Scaling analysis using Carroll and
Chang (1970)'s INdividual Differences SCALing method as implemented
using De Leeuw and Mair (2011)'s stress majorization algorithm.
}
\examples{
data(Namib)
plot(indscal(Namib$DZ,Namib$HM))
}
\references{
de Leeuw, J., & Mair, P. (2009). Multidimensional scaling using
majorization: The R package smacof. Journal of Statistical
Software, 31(3), 1-30, < http://www.jstatsoft.org/v31/i03/>
}
\author{
Jan de Leeuw and Patrick Mair
}
