% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_cvs.R
\name{qc_cvs}
\alias{qc_cvs}
\title{Check CV distribution}
\usage{
qc_cvs(
  data,
  grouping,
  condition,
  intensity,
  plot = TRUE,
  plot_style = "density"
)
}
\arguments{
\item{data}{a data frame containing at least peptide, precursor or protein identifiers,
information on conditions and intensity values for each peptide, precursor or protein.}

\item{grouping}{a character column in the \code{data} data frame that contains the grouping
variables (e.g. peptides, precursors or proteins).}

\item{condition}{a column in the \code{data} data frame that contains condition information
(e.g. "treated" and "control").}

\item{intensity}{a numeric column in the \code{data} data frame that contains the corresponding
raw or untransformed normalised intensity values for each peptide or precursor.}

\item{plot}{a logical value that indicates whether the result should be plotted.}

\item{plot_style}{a character value that indicates the plotting style. \code{plot_style = "boxplot"}
plots a boxplot, whereas \code{plot_style = "density"} plots the CV density distribution.
\code{plot_style = "violin"} returns a violin plot. Default is \code{plot_style = "density"}.}
}
\value{
Either a data frame with the median CVs in \% or a plot showing the distribution of the CVs
is returned.
}
\description{
Calculates and plots the coefficients of variation for the selected grouping.
}
\examples{
# Load libraries
library(dplyr)

set.seed(123) # Makes example reproducible

# Create example data
data <- create_synthetic_data(
  n_proteins = 100,
  frac_change = 0.05,
  n_replicates = 3,
  n_conditions = 2,
  method = "effect_random"
) \%>\%
  mutate(intensity_non_log2 = 2^peptide_intensity_missing)

# Calculate coefficients of variation
qc_cvs(
  data = data,
  grouping = peptide,
  condition = condition,
  intensity = intensity_non_log2,
  plot = FALSE
)

# Plot coefficients of variation
# Different plot styles are available
qc_cvs(
  data = data,
  grouping = peptide,
  condition = condition,
  intensity = intensity_non_log2,
  plot = TRUE,
  plot_style = "violin"
)
}
