% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/try_query.R
\name{try_query}
\alias{try_query}
\title{Query from url}
\usage{
try_query(
  url,
  max_tries = 5,
  silent = TRUE,
  header = TRUE,
  sep = "\\t",
  quote = FALSE
)
}
\arguments{
\item{url}{The url of the website that contains the table that should be downloaded.}

\item{max_tries}{Number of times the function tries to download the data in case an error occures.}

\item{silent}{Logical, if TRUE no individual messages are printed after each try that failed.}

\item{header}{Logical, indicates if the first row of the data frame contains variable names.}

\item{sep}{The separator of the table at the target url. Default is tab.}

\item{quote}{Logical, determines if quoting in character vectors should be considered or not. If TRUE, " and ' are escaped with \.}
}
\value{
A data frame that contains the table from the url.
}
\description{
Downloads data from url. If an error occures during the query (for example due to no connection) the function waits 3 seconds and tries again.
}
