# protViz - Visualizing and Analyzing Mass Spectrometry Related Data in Proteomics

## Documentation

The package ships with two pdf vignettes.

```
vignette('protViz')
vignette('PTM_MarkerFinder')
```

## Installation

### CRAN

```
install.packages('protViz')
```


### from [github](https://github.com/protViz/protViz)

install the latest development version

```{r}
install.packages('devtools')
library(devtools)
install_git('https://github.com/protViz/protViz', build_vignettes = TRUE, quiet = FALSE)
library(protViz)
```


### R CMD build hints


```{r}
Rcpp::compileAttributes()

tools::package_native_routine_registration_skeleton(".", character_only = FALSE)


RcppExport SEXP _rcpp_module_boot_MyModule();

static const R_CallMethodDef CallEntries[] = {
    {"_rcpp_module_boot_MyModule", (DL_FUNC) &_rcpp_module_boot_MyModule, 0},
    {NULL, NULL, 0}
};

RcppExport void R_init_minModuleEx(DllInfo *dll) {
    R_registerRoutines(dll, NULL, CallEntries, NULL, NULL);
    R_useDynamicSymbols(dll, FALSE);
}

```

### Docker

```
docker pull cpanse/protviz \
&& docker run -d -p 8792:8787 cpanse/protviz     
```

connect to http://yourdockerhost:8791  using a web browser

* username: rstudio
* password: rstudio


## Documentation

The package ships with a package vignette (browseVignettes('protViz') and a reference manual (just type ?protViz on the R shell).

Both documents are also available on the [package's CRAN](https://CRAN.R-project.org/package=protViz) page.


## Related approaches

* [RforProteomics](http://bioconductor.org/packages/RforProteomics/)

[![Research software impact](http://depsy.org/api/package/cran/protViz/badge.svg)](http://depsy.org/package/r/protViz)
