% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6-propdViz.R
\name{shale}
\alias{shale}
\title{Build \code{propd} Results Table}
\usage{
shale(object, cutoff = 1000, k, prompt = TRUE, clean = FALSE)
}
\arguments{
\item{object}{A \code{propr} or \code{propd} object.}

\item{cutoff}{For \code{updateCutoffs}, a numeric vector.
this argument provides the FDR cutoffs to test.
For graph functions, a numeric scalar. This argument
indicates the maximum theta to include in the figure.
For graph functions, a large integer will instead
retrieve the top N pairs as ranked by theta.}

\item{k}{An integer. For \code{propr} methods, the number
of co-clusters (where all pairs receive a specified color
if and only if both members belong to same the cluster).
For \code{propd} methods, the maximum number of PALs to index
when calculating \code{\link{pals}} in the network.}

\item{prompt}{A logical scalar. Set to \code{FALSE} to disable
the courtesy prompt when working with big data.}

\item{clean}{A boolean. Toggles whether to remove pairs
with "Bridged" or "Missing" PALs. Used by \code{geyser},
\code{bowtie}, and \code{gemini}.}
}
\description{
Builds a table of within-group and total log-ratio
 variances, log-ratio means, and PALs (see: \code{\link{pals}}).
 If the argument \code{k} is provided, the table will
 label at most \code{k} top PALs. Just as each node
 gets assigned a PAL, \code{shale} aims to assign
 each edge a PAL. Edges that have a top PAL as one
 and only one of their nodes get assigned that PAL.
 Edges that have top PALs as both of their nodes
 get assigned "Bridged". Edges without a top PAL
 as one of their nodes will get assigned a PAL if
 either (a) both nodes have the same neighbor PAL
 or (b) one node has a "Missing" neighbor PAL.
 The \code{cutoff} argument guides the maximum value of
 theta above which to exclude the pair. A large integer
 \code{cutoff} will instead retrieve the top N pairs as
 ranked by theta.
}
