% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prompt-powerline.R
\name{new_prompt_powerline}
\alias{new_prompt_powerline}
\title{This is a Powerline-like prompt}
\usage{
new_prompt_powerline(
  parts = list("status", "memory", "loadavg", "path", "devtools", "git"),
  colors = powerline_colors(parts)
)
}
\arguments{
\item{parts}{List of strings and functions. Strings are for the
built-in powerline pieces, functions are arbitrary functions with
four parameters: \code{expr}, \code{value}, \code{ok} and \code{visible}, and they should
return a character string. The builtin pieces are:
\itemize{
\item \code{status}: Status of last command, a red or green box.
\item \code{memory}: Memory usage of the R process.
\item \code{loadavg}: The load average of the system, see \code{\link[ps:ps_loadavg]{ps::ps_loadavg()}}.
\item \code{path}: Current working directory.
\item \code{devtools}: Package(s) loaded by \code{\link[pkgload:load_all]{pkgload::load_all()}} or the same
function of devtools.
\item \code{git}: git status, see \code{\link[=prompt_git]{prompt_git()}}.
}}

\item{colors}{Colors of the parts. Builtin parts have default colors,
but you can change them.}
}
\value{
\code{make_prompt_powerline()} returns a function that you can
use with \code{\link[=set_prompt]{set_prompt()}}.
}
\description{
It is inspired by the \url{https://github.com/powerline/powerline}
project. This prompt uses some Unicode glyphs that work best
with the fonts specifically modified for Powerline:
https://github.com/powerline/fonts
It also works best on consoles that support ANSI colors.
}
\seealso{
Other example prompts: 
\code{\link{prompt_devtools}()},
\code{\link{prompt_fancy}()},
\code{\link{prompt_git}()},
\code{\link{prompt_mem}()},
\code{\link{prompt_runtime}()},
\code{\link{prompt_status}()}
}
\concept{example prompts}
