% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projpred-package.R
\docType{package}
\name{projpred-package}
\alias{projpred}
\alias{projpred-package}
\title{Projection predictive feature selection}
\description{
\pkg{projpred} is an \R package for performing a projection predictive
variable (or "feature") selection for generalized linear models (GLMs),
generalized linear multilevel (or "mixed") models (GLMMs), generalized
additive models (GAMs), and generalized additive multilevel (or "mixed")
models (GAMMs), with the support for additive models still being
experimental. Note that the term "generalized" includes the Gaussian family
as well.

The package is compatible with \pkg{rstanarm} and \pkg{brms}, but developers
of other packages are welcome to add new \code{\link[=get_refmodel]{get_refmodel()}} methods (which
enable the compatibility of their packages with \pkg{projpred}). Custom
reference models can also be used via \code{\link[=init_refmodel]{init_refmodel()}}. It is via custom
reference models that \pkg{projpred} supports the projection onto candidate
models whose predictor terms are not a subset of the reference model's
predictor terms. However, for \pkg{rstanarm} and \pkg{brms} reference models,
\pkg{projpred} only supports the projection onto \emph{submodels} of the reference
model. For the sake of simplicity, throughout this package, we use the term
"submodel" for all kinds of candidate models onto which the reference model
is projected, even though this term is not always appropriate for custom
reference models.

Currently, the supported families are \code{\link[=gaussian]{gaussian()}}, \code{\link[=binomial]{binomial()}} (and---via
\code{\link[brms:get_refmodel.brmsfit]{brms::get_refmodel.brmsfit()}}---also \code{\link[brms:brmsfamily]{brms::bernoulli()}}), as well as
\code{\link[=poisson]{poisson()}}.

The projection of the reference model onto a submodel can be run on multiple
CPU cores in parallel (across the projected draws). This is powered by the
\pkg{foreach} package. Thus, you can use any parallel (or sequential) backend
compatible with \pkg{foreach}, e.g., the backends from packages
\pkg{doParallel}, \pkg{doMPI}, or \pkg{doFuture}. Using the global option
\code{projpred.prll_prj_trigger}, you can modify the number of projected draws
below which no parallelization is used (even if a parallel backend is
registered). Such a "trigger" threshold exists because of the computational
overhead of a parallelization which makes parallelization only useful for a
sufficiently large number of projected draws. By default, parallelization is
turned off, which can also be achieved by supplying \code{Inf} (or \code{NULL}) to
option \code{projpred.prll_prj_trigger}. Note that we cannot recommend
parallelizing the projection on Windows because in our experience, the
parallelization overhead is larger there, causing a parallel run to take
longer than a sequential run. Also note that the parallelization works well
for GLMs, but for GLMMs, GAMs, and GAMMs, the fitted model objects are quite
big, which---when running in parallel---may lead to an excessive memory usage
which in turn may crash the R session. Thus, we currently cannot recommend
the parallelization for GLMMs, GAMs, and GAMMs.

The \href{https://mc-stan.org/projpred/articles/}{vignettes} (currently, there is
only a single one) illustrate how to use the \pkg{projpred} functions in
conjunction. Shorter examples are included here in the documentation.

Some references relevant for this package are given in section "References"
below. See \code{citation(package = "projpred")} for details on citing
\pkg{projpred}.
}
\section{Functions}{
\describe{
\item{\code{\link[=init_refmodel]{init_refmodel()}}, \code{\link[=get_refmodel]{get_refmodel()}}}{For setting up a reference model
(only rarely needed explicitly).}
\item{\code{\link[=varsel]{varsel()}}, \code{\link[=cv_varsel]{cv_varsel()}}}{For variable selection, possibly with
cross-validation (CV).}
\item{\code{\link[=summary.vsel]{summary.vsel()}}, \code{\link[=print.vsel]{print.vsel()}}, \code{\link[=plot.vsel]{plot.vsel()}},
\code{\link[=suggest_size.vsel]{suggest_size.vsel()}}, \code{\link[=solution_terms.vsel]{solution_terms.vsel()}}}{For post-processing the
results from the variable selection.}
\item{\code{\link[=project]{project()}}}{For projecting the reference model onto submodel(s).
Typically, this follows the variable selection, but it can also be applied
directly (without a variable selection).}
\item{\code{\link[=as.matrix.projection]{as.matrix.projection()}}}{For extracting projected parameter draws.}
\item{\code{\link[=proj_linpred]{proj_linpred()}}, \code{\link[=proj_predict]{proj_predict()}}}{For making predictions from a
submodel (after projecting the reference model onto it).}
}
}

\references{
Catalina, A., Bürkner, P.-C., and Vehtari, A. (2020). Projection predictive
inference for generalized linear and additive multilevel models.
\emph{arXiv:2010.06994}. URL: \url{https://arxiv.org/abs/2010.06994}.

Dupuis, J. A. and Robert, C. P. (2003). Variable selection in qualitative
models via an entropic explanatory power. \emph{Journal of Statistical Planning
and Inference}, \strong{111}(1-2):77–94. \doi{10.1016/S0378-3758(02)00286-0}.

Goutis, C. and Robert, C. P. (1998). Model choice in generalised linear
models: A Bayesian approach via Kullback–Leibler projections. \emph{Biometrika},
\strong{85}(1):29–37.

Piironen, J. and Vehtari, A. (2017). Comparison of Bayesian predictive
methods for model selection. \emph{Statistics and Computing}, \strong{27}(3):711-735.
\doi{10.1007/s11222-016-9649-y}.

Piironen, J., Paasiniemi, M., and Vehtari, A. (2020). Projective inference in
high-dimensional problems: Prediction and feature selection. \emph{Electronic
Journal of Statistics}, \strong{14}(1):2155-2197. \doi{10.1214/20-EJS1711}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://mc-stan.org/projpred/}
  \item \url{https://discourse.mc-stan.org}
  \item Report bugs at \url{https://github.com/stan-dev/projpred/issues/}
}

}
\author{
\strong{Maintainer}: Frank Weber \email{fweber144@protonmail.com}

Authors:
\itemize{
  \item Juho Piironen \email{juho.t.piironen@gmail.com}
  \item Markus Paasiniemi
  \item Alejandro Catalina \email{alecatfel@gmail.com}
  \item Aki Vehtari
}

Other contributors:
\itemize{
  \item Jonah Gabry [contributor]
  \item Marco Colombo [contributor]
  \item Paul-Christian Bürkner [contributor]
  \item Hamada S. Badr [contributor]
}

}
