% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R
\name{handlers}
\alias{handlers}
\title{Control How Progress is Reported}
\usage{
handlers(
  ...,
  append = FALSE,
  on_missing = c("error", "warning", "ignore"),
  default = handler_txtprogressbar,
  global = NULL
)
}
\arguments{
\item{\dots}{One or more progression handlers.  Alternatively, this
functions accepts also a single vector of progression handlers as input.
If this vector is empty, then an empty set of progression handlers will
be set.}

\item{append}{(logical) If FALSE, the specified progression handlers
replace the current ones, otherwise appended to them.}

\item{on_missing}{(character) If \code{"error"}, an error is thrown if one of
the progression handlers does not exists.  If \code{"warning"}, a warning
is produces and the missing handlers is ignored.  If \code{"ignore"}, the
missing handlers is ignored.}

\item{default}{The default progression calling handler to use if none
are set.}

\item{global}{If TRUE, then the global progression handler is enabled.
If FALSE, it is disabled.  If NA, then TRUE is returned if it is enabled,
otherwise FALSE.  Argument \code{global} must not used with other arguments.}
}
\value{
(invisibly) the previous list of progression handlers set.
If no arguments are specified, then the current set of progression
handlers is returned.
If \code{global} is specified, then TRUE is returned if the global progression
handlers is enabled, otherwise false.
}
\description{
Control How Progress is Reported
}
\details{
This function provides a convenient alternative for getting and setting
option \option{progressr.handlers}.

\emph{IMPORTANT: Setting progression handlers is a privilege that should be
left to the end user. It should not be used by R packages, which only task
is to \emph{signal} progress updates, not to decide if, when, and how progress
should be reported.}
}
\examples{
handlers("txtprogressbar")
if (requireNamespace("beepr", quietly = TRUE))
  handlers("beepr", append = TRUE)

with_progress({ y <- slow_sum(1:5) })
print(y)


if (getRversion() >= "4.0.0") {
  handlers(global = TRUE)
  y <- slow_sum(1:4)
  z <- slow_sum(6:9)
  handlers(global = FALSE)
}

}
