% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iprocessanimateR.R
\name{ianimate_process}
\alias{ianimate_process}
\title{Interactive Process Animation}
\usage{
ianimate_process(eventlog, min.time = 30, max.time = 600,
  default.time = 60)
}
\arguments{
\item{eventlog}{The event log object that should be animated}

\item{min.time}{Minimum animation time selectable}

\item{max.time}{Maximum animation time selectable}

\item{default.time}{Default animation time selectable}
}
\description{
Creates an interactive Shiny dashbord that allows to configure the animation produced by processanimateR.
}
\examples{
{
\dontrun{
library(eventdataR)
library(edeaR)
library(dplyr)
ianimate_process(sepsis \%>\%
 filter_trace_frequency(percentage = 0.2) \%>\%
 filter_activity(c("Return ER"), reverse = T) \%>\%
 # we fix the datatype of some of the attributes to allow proper rendering of the token color
 # the token size option currently only support numeric attributes
 mutate_at(c("lacticacid", "leucocytes", "crp", "age"), as.numeric) \%>\%
 mutate_at(c("disfuncorg", "sirscriteria2ormore", "infectionsuspected"), as.logical))
}
}

}
\seealso{
animate_process
}
\author{
Felix Mannhardt <felix.mannhardt@sintef.no> (SINTEF Technology and Society)
}
