% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prism_normals.R
\name{get_prism_normals}
\alias{get_prism_normals}
\title{Download data for 30 year normals of climate variables}
\usage{
get_prism_normals(type, resolution, mon = NULL, annual = FALSE,
  keepZip = TRUE)
}
\arguments{
\item{type}{The type of data to download, must be "ppt", "tmean", "tmin", or "tmax".
Note that tmean == mean(tmin, tmax).}

\item{resolution}{The spatial resolution of the data, must be either "4km" or "800m".}

\item{mon}{a numeric value for month, can be a numeric vector of months.}

\item{annual}{if TRUE download annual data}

\item{keepZip}{if TRUE, leave the downloaded zip files in your 'prism.path', if FALSE, they will be deleted}
}
\description{
Download data from the prism project for 30 year normals at 4km or 800m grid cell resolution for precipitation, mean, min and max temperature
}
\details{
You must make sure that you have set up a valid download directory.  This must be set as options(prism.path = "YOURPATH")
}
\examples{
\dontrun{
### Get 30 year normal values for rainfall
get_prism_normals(type="ppt",resolution = "4km",mon = 1, keepZip=FALSE)

}
}
