% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prism_annual.R
\name{get_prism_annual}
\alias{get_prism_annual}
\title{Download annual daily averages}
\usage{
get_prism_annual(type, years = NULL, keepZip = TRUE)
}
\arguments{
\item{type}{The type of data to download, must be "ppt", "tmean", "tmin",
"tmax", or "all", which downloads "ppt", "tmin", and "tmax". Note that
tmean == mean(tmin, tmax).}

\item{years}{a valid numeric year, or vector of years, to download data for.
If no month is specified, year averages for that year will be downloaded.}

\item{keepZip}{if \code{TRUE}, leave the downloaded zip files in your
'prism.path', if \code{FALSE}, they will be deleted.}
}
\description{
Download annual daily average data from the prism project at 4km grid cell
resolution for precipitation, mean, min and max temperature
}
\details{
Data is available from 1891 until 2014, however you have to download
all data for years prior to 1981.  Therefore if you enter a vector of years
that bounds 1981, you will automatically download all data for all years in
the vector.  If the "all" parameter is set to TRUE, it will override any
months entered and download all data. Data will be downloaded for all months
in all the years in the vectors supplied. You must make sure that you have
set up a valid download directory.  This must be set as
\code{options(prism.path = "YOURPATH")}.
}
\examples{
\dontrun{
### Get all the data for January from 1990 to 2000
get_prism_annual(type="tmean", year = 1990:2000, keepZip=FALSE)
}

}
