% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{get_metadata}
\alias{get_metadata}
\title{Get PRISM metadata}
\usage{
get_metadata(type, dates = NULL, minDate = NULL, maxDate = NULL)
}
\arguments{
\item{type}{The type of data to download, must be "ppt", "tmean", "tmin", or "tmax".
Note that tmean == mean(tmin, tmax).}

\item{dates}{a vector of iso-8601 formatted dates to download data for, can
also be a single date. May be provided as either a character or
\code{\link[base]{Date}} class.}

\item{minDate}{a valid iso-8601 (e.g. YYYY-MM-DD) date to start downloading data.
May be provided as either a character or \code{\link[base]{Date}} class.}

\item{maxDate}{a valid iso-8601 (e.g. YYYY-MM-DD) date to end downloading data.
May be provided as either a character or \code{\link[base]{Date}} class.}
}
\value{
list of data.frames containing metadata. If only
one date is requested, the function returns the data.frame.
}
\description{
Retrieves PRISM metadata for a given type and
date range. The information is retrieved from the .info.txt file.
}
