% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglinear_interpolation.R
\name{loglinear_interpolation}
\alias{loglinear_interpolation}
\title{Log-linear interpolation}
\usage{
loglinear_interpolation(
  x,
  coordinate_one_x,
  coordinate_one_y,
  coordinate_two_x,
  coordinate_two_y
)
}
\arguments{
\item{x}{\code{numeric} \emph{x} values for which interpolate \emph{y}
values.}

\item{coordinate_one_x}{\code{numeric} value for lower \emph{x}-coordinate.}

\item{coordinate_one_y}{\code{numeric} value for lower \emph{y}-coordinate.}

\item{coordinate_two_x}{\code{numeric} value for upper \emph{x}-coordinate.}

\item{coordinate_two_y}{\code{numeric} value for upper \emph{y}-coordinate.}
}
\value{
\code{numeric} values.
}
\description{
Log-linearly interpolate values between two thresholds.
}
\details{
Values are log-linearly interpolated at the \emph{x}-coordinates
specified in \code{x} using the lower and upper coordinate arguments to
define the line. Values lesser or greater than these numbers are assigned
the minimum and maximum \emph{y} coordinates.
}
\examples{
# create series of x-values
x <- seq(0, 1000)

# interpolate y-values for the x-values given the two reference points:
# (200, 100) and (900, 15)
y <- loglinear_interpolation(x, 200, 100, 900, 15)

# plot the interpolated values
\dontrun{
plot(y ~ x)

# add the reference points to the plot (shown in red)
points(x = c(200, 900), y = c(100, 15), pch = 18, col = "red", cex = 2)
}
}
