% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_feature_weights.R
\name{add_feature_weights}
\alias{add_feature_weights}
\title{Add feature weights}
\usage{
add_feature_weights(x, weights)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{weights}{\code{numeric} weights. Features with higher weights indicate
that it is more desirable to represent them in the solution. Weights
cannot have negative values.}
}
\value{
\code{\link{ConservationProblem-class}} object with the weights
  added to it.
}
\description{
Conservation planning problems that aim to maximize the representation of
features may not be able to conserve all of them if the budget is not high
enough. In such budget-limited problems, it may be desirable to prefer the
representation of some features over other features. Weights can be
applied to a problem to favor the representation of some features over other
features when making decisions about how the budget should be allocated.
}
\details{
Weights can only be applied to a budget-limited
  type of planning problem (i.e. \code{\link{add_max_cover_objective}},
  and \code{\link{add_max_features_objective}}. Weights can also
  be applied to problems that aim to maximize phylogenetic representation
  (\code{\link{add_max_phylo_objective}}) to favor the
  representation of specific features over the representation of
  some phylogenetic branches.
}
\examples{
# create problem
p <- problem(sim_pu_raster, sim_features) \%>\%
     add_max_cover_objective(budget = 5000)

# problem problem with features weighted according to rarity
# (1 / number occurrences)
w1 <- 1 / cellStats(sim_features, "sum") * 1000
p1 <- p \%>\% add_feature_weights(w1)

# problem problem with features weighted according to manually specified
# weights
w2  <- c(0.1, 0.2, 0.3, 0.4, 0.5)
p2 <- p \%>\% add_feature_weights(w2)
\donttest{
# solve solutions
s <- stack(solve(p), solve(p1), solve(p2))

# plot solutions
plot(s, main = c("equal weights", "rarity weights", "manual weights"),
     axes = FALSE, box = FALSE)
}

}
\seealso{
\code{\link{targets}}, \code{\link{objectives}}.
}
