% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulationsfunctions.R
\name{simulate_incidence_stats_fast}
\alias{simulate_incidence_stats_fast}
\title{Function to calculate theoretical value for x.loi and I}
\usage{
simulate_incidence_stats_fast(P, dist.X.loi, dist.X.los = NA)
}
\arguments{
\item{P}{prevalence of HAIs}

\item{dist.X.loi}{probability mass function of distribution of lengths of infection}

\item{dist.X.los}{vector of probabilities for values 1:length(dist.X.los) of X.los}
}
\value{
list with following components \itemize{
   \item{x.loi - average length of infection}
   \item{x.los - average length of stay}
   \item{I - theoretical incidence rate per patient day}
   \item{I.pp - theoretical incidence proportion per admission}
}
}
\description{
Function to calculate theoretical value for x.loi and I
}
\examples{
example.dist <- create_dist_vec(function(x) dpois(x-1, 7), 70)
data.fast.inc.theo <- simulate_incidence_stats_fast(P=0.05, dist.X.loi = example.dist)
data.fast.inc.theo$x.loi
data.fast.inc.theo$I
}
