% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcs_ptp.R
\name{calculate_dcs_1993_lm_cad_ptp}
\alias{calculate_dcs_1993_lm_cad_ptp}
\title{Calculate 1993 Duke Clinical Score for Left Main Disease}
\usage{
calculate_dcs_1993_lm_cad_ptp(
  age,
  sex,
  have_typical_chest_pain,
  have_peripheral_vascular_disease,
  have_cerebrovascular_disease,
  have_carotid_bruits,
  duration_of_cad_symptoms_year,
  max_na_vascular_disease_index = 0,
  max_age = 65
)
}
\arguments{
\item{age}{Input integer value to indicate the age of the patient.}

\item{sex}{Input characters (female, male) to indicate the sex of the patient.
\itemize{
  \item female
  \item male
}}

\item{have_typical_chest_pain}{Input characters (no, yes) to indicate if the patient
has typical chest pain.
\itemize{
  \item no stands for the patient not having typical chest pain.
  \item yes stands for the patient having typical chest pain.
}}

\item{have_peripheral_vascular_disease}{Input characters (no, yes) to indicate if the patient
has peripheral vascular disease.
\itemize{
  \item no stands for not having peripheral vascular disease.
  \item yes stands for having peripheral vascular disease.
}}

\item{have_cerebrovascular_disease}{Input characters (no, yes) to indicate if the patient
has cerebrovascular disease.
\itemize{
  \item no stands for not having cerebrovascular disease.
  \item yes stands for having cerebrovascular disease.
}}

\item{have_carotid_bruits}{Input characters (no, yes) to indicate if the patient
has carotid bruits.
\itemize{
  \item no stands for not having carotid bruits.
  \item yes stands for having carotid bruits.
}}

\item{duration_of_cad_symptoms_year}{Input integer to indicate the duration of
coronary artery disease symptoms in years.}

\item{max_na_vascular_disease_index}{Input integer 0 to 3 to indicate the maximum number of
missing disease history to tolerate before outputting an \code{NA}.
Default: 0}

\item{max_age}{Input positive integer to
indicate the maximum age to tolerate before outputting an \code{NA}.
In the Duke Clinical Score 1993 paper, the maximum value is set as 65.
Default: 65}
}
\value{
A numeric value representing the patient's PTP for left main disease
(>75\% luminal diameter narrowing of the left main coronary artery)
based on the 1993 Duke Clinical Score.
}
\description{
This function returns a patient's
pre-test probability (PTP) of severe (>75\% luminal diameter narrowing
of the left main coronary artery)
coronary artery disease based on the
1993 Duke Clinical Score.
}
\details{
The predictive model is based on
patients referred for cardiac catheterisation between 1969 and 1983.
}
\examples{
# 40 year old female with typical chest pain for one year,
# She has peripheral vascular and cerebrovascular disease.

calculate_dcs_1993_lm_cad_ptp(
    age = 40,
    sex = "female",
    have_typical_chest_pain = "yes",
    have_peripheral_vascular_disease = "yes",
    have_cerebrovascular_disease = "yes",
    have_carotid_bruits = "no",
    duration_of_cad_symptoms_year = 1,
)

}
