% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPredict.R
\name{ggPredict}
\alias{ggPredict}
\title{Visualize predictions from the multiple regression models.}
\usage{
ggPredict(fit, pred = NULL, modx = NULL, mod2 = NULL,
  modx.values = NULL, mod2.values = NULL, mode = 1, colorn = 3,
  maxylev = 6, show.point = TRUE, show.error = FALSE,
  jitter = NULL, se = FALSE, alpha = 0.1, show.text = TRUE,
  add.modx.values = TRUE, add.loess = FALSE, labels = NULL,
  angle = NULL, xpos = NULL, vjust = NULL, digits = 2,
  facet.modx = FALSE, facetbycol = TRUE, plot = TRUE, ...)
}
\arguments{
\item{fit}{An object of class "lm" or "glm"}

\item{pred}{The name of predictor variable}

\item{modx}{Optional. The name of moderator variable}

\item{mod2}{Optional. The name of second moderator variable}

\item{modx.values}{For which values of the moderator should lines be plotted? Default is NULL. If NULL, then the customary +/- 1 standard deviation from the mean as well as the mean itself are used for continuous moderators. If the moderator is a factor variable and modx.values is NULL, each level of the factor is included.}

\item{mod2.values}{For which values of the second moderator should lines be plotted? Default is NULL. If NULL, then the customary +/- 1 standard deviation from the mean as well as the mean itself are used for continuous moderators. If the moderator is a factor variable and modx.values is NULL, each level of the factor is included.}

\item{mode}{A  numeric. Useful when the variables are numeric. If 1, c(-1,0,1)*sd + mean is used. If 2, the 14th, 50th, 86th percentile values used. If 3 sequence over a the range of a vector used}

\item{colorn}{The number of regression lines when the modifier variable(s) are numeric.}

\item{maxylev}{An integer indicating the maximum number of levels of numeric variable be treated as a categorical variable}

\item{show.point}{Logical. Whether or not add points}

\item{show.error}{Logical. Whether or not show error}

\item{jitter}{logical Whether or not use geom_jitter}

\item{se}{Logical. Whether or not add confidence interval}

\item{alpha}{A numeric. Transparency}

\item{show.text}{Logical. Whether or not add regression equation as label}

\item{add.modx.values}{Logical. Whether or not add moderator values to regression equation}

\item{add.loess}{Logical. Whether or not add loess line}

\item{labels}{labels on regression lines}

\item{angle}{angle of text}

\item{xpos}{x axis position of label}

\item{vjust}{vertical alignment of labels}

\item{digits}{integer indicating the number of decimal places}

\item{facet.modx}{Create separate panels for each level of the moderator? Default is FALSE}

\item{facetbycol}{Logical.}

\item{plot}{Logical. Should a plot of the results be printed? Default is TRUE.}

\item{...}{additional arguments to be passed to geom_text}
}
\description{
Visualize predictions from the multiple regression models.
}
\examples{
fit=loess(mpg~hp*wt*am,data=mtcars)
ggPredict(fit)
ggPredict(fit,hp)
ggPredict(fit,hp,wt)
fit=lm(mpg~hp*wt,data=mtcars)
ggPredict(fit)
ggPredict(fit,labels=paste0("label",1:3),xpos=c(0.3,0.6,0.4))
ggPredict(fit,se=TRUE)
ggPredict(fit,mode=3,colorn=40,show.text=FALSE)
\donttest{
fit=lm(mpg~hp*wt*cyl,data=mtcars)
ggPredict(fit,modx=wt,modx.values=c(2,3,4,5),mod2=cyl,show.text=FALSE)
ggPredict(fit,hp,wt,show.point=FALSE,se=TRUE,xpos=0.5)
ggPredict(fit,modx=wt,xpos=0.3)
ggPredict(fit)
mtcars$engine=ifelse(mtcars$vs==0,"V-shaped","straight")
fit=lm(mpg~wt*engine,data=mtcars)
ggPredict(fit)
require(TH.data)
fit=glm(cens~pnodes*horTh,data=GBSG2,family=binomial)
ggPredict(fit,pnodes,horTh,se=TRUE,xpos=c(0.6,0.3),angle=c(40,60),vjust=c(2,-0.5))
fit1=glm(cens~pnodes,data=GBSG2,family=binomial)
ggPredict(fit1,vjust=1.5,angle=45)
fit3=glm(cens~pnodes*age,data=GBSG2,family=binomial)
ggPredict(fit3,pred=pnodes,modx=age,mode=3,colorn=10,show.text=FALSE)
fit2=glm(cens~pnodes*age*horTh,data=GBSG2,family=binomial)
ggPredict(fit2,pred=pnodes,modx=age,mod2=horTh,mode=3,colorn=10,show.text=FALSE)
fit=lm(mpg~log(hp)*wt,data=mtcars)
ggPredict(fit,hp,wt)
}
}
