% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pplot.spi.r
\name{pplot.spi}
\alias{pplot.spi}
\alias{precintcon.plot.spi}
\title{Plot Standardized Precipitation Index}
\usage{
pplot.spi(\dots, period = 3, distribution = "Gamma", xlab = "Months",
ylab = "SPI", ylim = c(-3,3), legend = NULL, fontsize = 10,
axis.text.color = "black", export = FALSE, export.name = "spi_plot.png",
width = 8.6, height = 7.5, units = "cm")
}
\arguments{
\item{period}{the number of months to be aggregated for calculating
the standardized precipitation index. (Default value: 3)}

\item{distribution}{it has no effect yet. (Default value: "Gamma")}

\item{xlab}{the text for the x axis. (Default value: "Months")}

\item{ylab}{the text for the y axis. (Default value: "SPI")}

\item{ylim}{the limits of the y axis. (Default value: c(-3, 3))}

\item{legend}{the text vector for the legend items. If NULL the legends will
be equals to the variable names. (Default value: NULL)}

\item{fontsize}{the font size value in pt. (Default value: 10)}

\item{axis.text.color}{the legend colors. (Default value: "black")}

\item{export}{the logical value for defining whether the graph should be export
to a file or not. (Default value: FALSE)}

\item{export.name}{the text for defining the exported file name. It is only used
if export = TRUE. (Default value: "spi_plot.png")}

\item{width}{the number for defining the exported graph width. It is only used if
export = TRUE. (Default value: 8.6)}

\item{height}{the number for defining the exported graph height. It is only used
if export = TRUE. (Default value: 7.5)}

\item{units}{the text for defining the units of the height and width parameters.
It is only used if export = TRUE. (Default value: "cm")}

\item{\dots}{a set of daily or monthly precipitation series.}
}
\description{
Plots the Standardized Precipitation Index of a precipitation
serie.
}
\examples{
##
# Loading the daily precipitation serie.
data(daily)

##
# Performing the a set of statistical analysis
pplot.spi(daily)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{read.data}}
}
\keyword{index}
\keyword{precipitation}
\keyword{standardized}

