% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mi_pre.R
\name{mi_mean}
\alias{mi_mean}
\title{Compute the average dataset over imputed datasets.}
\usage{
mi_mean(data)
}
\arguments{
\item{data}{List of imputed datasets to compute the average dataset over.}
}
\value{
A dataset that is the average over the imputed datasets specified
with \code{data}. For continuous predictors, the mean over imputed values is
returned, for categorical predictors, the majority class ovder imputed values
is returned. In case of a non-unique maximum, the value is sampled from the 
class with identical maximum counts.
}
\description{
\code{mi_mean} computes the averages dataset over a list of imputed datasets.
Can be used to reduce computation time of functions \code{singleplot} and 
\code{pairplot}.
}
\details{
It is assumed every imputed dataset contains the same observations 
(but not the same values) in the same order.
}
\seealso{
\code{\link{mi_pre}}, \code{\link{singleplot}}, \code{\link{pairplot}}
}
