% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{interact}
\alias{interact}
\title{Calculate interaction statistics for user-specified variables}
\usage{
interact(object, varnames = NULL, nullmods = NULL, k = 10, plot = TRUE,
  col = c("yellow", "blue"), ylab = "Interaction strength",
  main = "Interaction test statistics", ...)
}
\arguments{
\item{object}{an object of class \code{\link{pre}}.}

\item{varnames}{character vector. Names of variables for which interaction 
statistics should be calculated.}

\item{nullmods}{object with bootstrapped null interaction models, resulting 
from application of \code{bsnullinteract}.}

\item{k}{integer. Calculating interaction test statistics is a computationally 
intensive, so  calculations are split up in several parts to prevent memory 
allocation errors. If a memory allocation error still occurs, increase k.}

\item{plot}{logical Should the interaction statistics be plotted?}

\item{col}{character vector of length two. Color for plotting bars used. Only 
used when plot = TRUE. Only first element of vector is used if 
\code{nullmods = NULL}.}

\item{ylab}{character string. Label to be used for plotting y-axis.}

\item{main}{character. Main title for the bar plot.}

\item{...}{Additional arguments to be passed to \code{barplot}.}
}
\value{
If nullmods is not specified, the function returns the interaction 
test statistic. If nullmods is specified, the function returns a list, 
with elements \code{$H}, which is the test statistic of the interaction 
strength, and \code{$nullH}, which is a vector of test statistics of the 
interaction in each of the bootstrapped null interaction models. In the barplot,
yellow is used for plotting the interaction test statistic. When applicable, 
blue is used for the mean in the bootstrapped null models.
}
\description{
\code{interact} calculates a statistic for assessing the presence of 
interactions between the input variable(s) specified, and all other input
variables.
}
\details{
Can be computationally intensive, especially when nullmods is specified.
}
\examples{
\donttest{
 airq.ens <- pre(Ozone ~ ., data=airquality[complete.cases(airquality),])
 interact(airq.ens, c("Temp", "Wind", "Solar.R"))}
}

