\name{prabtest}
\alias{prabtest}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Parametric bootstrap test for clustering in presence-absence matrices}
\description{
  Parametric bootstrap test of a null model of i.i.d., but spatially
  autocorrelated species against clustering of the species' occupied
  areas (or alternatively nestedness). In spite of the lots of
  parameters, a standard execution (for the default test statistics, see
  parameter \code{teststat} below) will be \cr
  \code{prabmatrix <- prabinit(file="path/prabmatrixfile",
    neighborhood="path/neighborhoodfile")}\cr
  \code{test <- prabtest(prabmatrix)}\cr
  \code{summary(test)}\cr
  \bold{Note:} Data formats are described
  on the \code{prabinit} help page. You may also consider the example datasets
  \code{kykladspecreg.dat} and \code{nb.dat}. Take care of the
  parameter \code{rows.are.species} of \code{prabinit}.}


\usage{
prabtest(x, teststat = "distratio", tuning=switch(teststat,distratio=0.25,
lcomponent=floor(3*ncol(x$distmat)/4),
isovertice=ncol(x$distmat),nn=4,NA), times = 1000, pd = NULL,
prange = c(0, 1), nperp = 4, step = 0.1, step2=0.01,
twostep = TRUE, sf.sim = FALSE,
sf.const = sf.sim, pdfnb=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{an object of class \code{prab} (presence-absence data), as
    generated by \code{prabinit}.}
  \item{teststat}{string, indicating the test statistics. \code{"isovertice"}:
    number of isolated vertices in the graph of \code{tuning}
    smallest distances
    between species. \code{"lcomponent"}: size of largest connectivity
    component in this graph. \code{"distratio"}: ratio between \code{tuning}
    smallest and largest distances. \code{"nn"}: average distance of species to
    \code{tuning}th nearest neighbor. 
    \code{"inclusions"}: number of inclusions between areas of different
    species (tests for nestedness structure, not for clustering).}
  \item{tuning}{integer or (if \code{teststat="distratio"}) numerical
    between 0 and 1. Tuning constant for test statistics, see
    \code{teststat}.}
  \item{times}{integer. Number of simulation runs.}
  \item{pd}{numerical between 0 and 1. The probability that a new
    region is drawn from the non-neighborhood of the previous regions
    belonging to a species under generation. If \code{NA} (the default),
    \code{prabtest} estimates this by function
    \code{autoconst}. Otherwise the next five parameters have no effect.}
  \item{prange}{numerical range vector, lower value not smaller than 0, larger
    value not larger than 1. Range where \code{pd} is to be found. Used
    by function \code{autoconst}.}
  \item{nperp}{integer. Number of simulations per \code{pd}-value. Used
    by function \code{autoconst}.}
  \item{step}{numerical between 0 and 1. Interval length between
    subsequent choices of \code{pd} for the first simulation. Used
    by function \code{autoconst}.}
  \item{step2}{numerical between 0 and 1. Interval length between
    subsequent choices of \code{pd} for the second simulation (see
    parameter \code{twostep}). Used
    by function \code{autoconst}.}
  \item{twostep}{logical. If \code{TRUE}, a first estimation step for
    \code{pd} is
    carried out in the whole \code{prange}, and then the final
    estimation is determined between the preliminary estimator
    \code{-5*step2} and \code{+5*step2}. Else, the first simulation
    determines the final estimator. Used
    by function \code{autoconst}.}
  \item{sf.sim}{logical. Indicates if the range sizes of the species
    are held fixed
    in the test simulation (\code{TRUE}) or generated from their empirical
    distribution in \code{x} (\code{FALSE}). See function \code{randpop.nb}.}
  \item{sf.const}{logical. Same as \code{sf.sim}, but for estimation of
    \code{pd} by \code{autoconst}.}
  \item{pdfnb}{logical. If \code{TRUE}, the probabilities of the regions
    are modified according to the number of neighboring regions in
    \code{randpop.nb}, see Hennig and Hausdorf (2002), p. 5. This is
    usually no improvement.}
}
\details{
  From the original data, the distribution of the
  range sizes of the species, the autocorrelation parameter \code{pd}
  (estimated by \code{autoconst}) and the distribution on the regions
  induced by the relative species numbers are taken. With these
  parameters, \code{times} populations according to the null model
  implemented in \code{randpop.nb} are generated and the test statistic
  is evaluated. The resulting p-value is number of simulated statistic
  values more extreme than than the value of the original data\code{+1}
  divided by \code{times+1}. "More extreme" means smaller for
  \code{"lcomponent"}, \code{"distratio"}, \code{"nn"}, larger for
  \code{"inclusions"}, and
  twice the smaller number between the original statistic value and the
  "border", i.e., a two-sided test for \code{"isovertice"}.
  If \code{pd=NA} was
  specified, a diagnostic plot
  for the estimation of \code{pd} is plotted by \code{autoconst}.
  For details see Hennig
  and Hausdorf (2004) and the help pages of the cited functions. 
}
\value{
  An object of class \code{prabtest}, which is a list with components
  \item{results}{vector of test statistic values for all simulated
    populations.}
  \item{datac}{test statistic value for the original data.'}
  \item{p.value}{the p-value.}
  \item{tuning}{see above.}
  \item{pd}{see above.}
  \item{reg}{regression coefficients from \code{autoconst}.}
  \item{teststat}{see above.}
  \item{distance}{the distance measure chosen, see \code{prabinit}.}
  \item{gtf}{the geco-distance tuning parameter (only informative if
    \code{distance="geco"}), see \code{prabinit}.}
  \item{times}{see above.}
  \item{pdfnb}{see above.}
}

\references{
Hennig, C. and Hausdorf, B. (2004) Distance-based parametric bootstrap
tests for clustering of species ranges. \emph{Computational Statistics
  and
  Data Analysis} 45, 875-896.
\url{http://stat.ethz.ch/Research-Reports/110.html}.

Hausdorf, B. and Hennig, C. (2003)  Biotic Element Analysis in
Biogeography. \emph{Systematic Biology} 52, 717-723.

Hausdorf, B. and Hennig, C. (2003) Nestedness of north-west European
land snail ranges as a consequence of differential immigration from
Pleistocene glacial refuges. \emph{Oecologia} 135, 102-109.
}
\author{Christian Hennig
  \email{chrish@stats.ucl.ac.uk}
  \url{http://www.homepages.ucl.ac.uk/~ucakche}}


\seealso{
  \code{\link{prabinit}} generates objects of class \code{prab}.
  
  \code{\link{autoconst}} estimates \code{pd} from such objects.
  
  \code{\link{randpop.nb}} generates populations from the null model.
  An alternative model is given by \code{\link{cluspop.nb}}.

  Some more information on the test statistics is given in
  \code{\link{homogen.test}}, \code{\link{lcomponent}},
  \code{\link{distratio}}, \code{\link{nn}},
  \code{\link{incmatrix}}.

  The simulations are computed by \code{\link{pop.sim}}.

  Summary and print methods: \code{\link{summary.prabtest}}.
}


\examples{
data(kykladspecreg)
data(nb)
set.seed(1234)
x <- prabinit(prabmatrix=kykladspecreg, neighborhood=nb)
# If you want to use your own ASCII data files, use
# x <- prabinit(file="path/prabmatrixfile",
# neighborhood="path/neighborhoodfile")
prabtest(x, times=5, pd=0.35)
# These settings are chosen to make the example execution
# a bit faster; usually you will use prabtest(kprab).
}
\keyword{cluster}% at least one, from doc/KEYWORDS
\keyword{spatial}% __ONLY ONE__ keyword per line
