% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formantplot.R
\name{formantplot}
\alias{formantplot}
\title{Plot formant object}
\usage{
formantplot(
  fm,
  start,
  end,
  tfrom0 = TRUE,
  tgbool = FALSE,
  lines = NULL,
  focusTierColor = "black",
  focusTierLineType = "dotted",
  dynamicRange = 30,
  freqRange = c(0, 5500),
  plotType = "speckle",
  color = "black",
  ind = NULL,
  min_max_only = FALSE,
  axisLabel = "Frequency (Hz)",
  drawSize = 1,
  speckleSize = 1
)
}
\arguments{
\item{fm}{Formant object loaded using \link[rPraat:formant.read]{rPraat::formant.read}}

\item{start}{Start time (in seconds) of desired plotted area.}

\item{end}{End time (in seconds) of desired plotted area.}

\item{tfrom0}{Logical; should time on the x-axis run from 0 or from the
original time? Default is \code{TRUE}.}

\item{tgbool}{Logical; should dotted lines be plotted corresponding to
locations in a TextGrid? Default is \code{FALSE}.}

\item{lines}{Numeric vector giving locations in seconds of locations from
a TextGrid to be plotted with dotted lines. Default is \code{NULL}.}

\item{focusTierColor}{String or vector of strings giving the color(s) to
use for plotting focus tier lines. If multiple tiers are focused, a vector
of the same length can be passed, and the nth tier will be plotted in the
nth color. Default is \code{'black'}.}

\item{focusTierLineType}{String or vector of strings giving the line
type(s) for plotting focus tier lines. If multiple tiers are focused, a
vector of the same length can be passed, and the nth tier will be plotted in
the nth line type. Default is \code{'dotted'}.}

\item{dynamicRange}{Dynamic range in dB for producing formant plots.
When a formant plot of \code{plotType='speckle'} is drawn, no formants are
shown in frames with intensity level \code{dynamicRange} below the maximum
intensity. Default is \code{30}. If set to \code{0}, all formants are shown.}

\item{freqRange}{Vector of two integers giving the frequency range to be
used for producing formant plots. Default is \code{c(0,5500)}.}

\item{plotType}{String giving the type of formant plot to produce;
default is \code{speckle} (a point plot), the only other option is \code{draw} (a line
plot). Alternatively a vector \code{c('draw','speckle')} can be passed, in which
case both are used.}

\item{color}{String or vector of strings giving the name(s) of
colors to be used for plotting formants. If one color is provided, all
formants will be plotted in this color. If multiple colors are provided,
different formants will be shown in different colors. Default is \code{'black'}.}

\item{ind}{Integer indexing waveform relative to other plot components.
Default is \code{NULL}.}

\item{min_max_only}{Logical; should only minimum and maximum values be given
on the y-axis? Default is \code{FALSE}. Can also be a logical vector if some but
not all plot components should have minimum and maximum values on the y-axis.
Ignored for TextGrid component.}

\item{axisLabel}{String giving the name of the label to print along the
y-axis when plotting formants. Default is \code{Frequency (Hz)}.}

\item{drawSize}{Number indicating the line width if
\code{plotType} is \code{'draw'}. Default is \code{1}. Controls the \code{lwd} argument of
\link[graphics:lines]{graphics::lines}.}

\item{speckleSize}{Number indicating the point size of if \verb{_plotType} is
\code{'speckle'}. Default is \code{1}. Controls the \code{cex} arguments of
\link[graphics:points]{graphics::points}.}
}
\value{
No return values, called internally by \link{praatpicture} and sibling
functions.
}
\description{
Function for plotting formant objects called by \link{praatpicture}. Instead of
using this function directly, just use
\code{praatpicture('my_sound_file', frames='formant')}.
}
\examples{
# Don't use directly
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/1.wav')
praatpicture(soundFile, frames='formant')
}
