% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VPC.r
\name{get_sds}
\alias{get_sds}
\title{Calculate the model implied standard deviations per time point}
\usage{
get_sds(object, treatment = "treatment", n = 1)
}
\arguments{
\item{object}{An object created by \code{\link{study_parameters}}}

\item{treatment}{\code{character}; either \code{"treatment"} or \code{"control"}.
Indicates for which group SDs should be calculated for. This only makes a difference
for 3-level partially nested designs.}

\item{n}{Optional; selects row n if \code{object} is a \code{data.frame} of
parameters}
}
\value{
\code{data.frame} with class \code{plcp_sds} containing the model
implied standard deviations per time point.
}
\description{
Calculate the model implied standard deviations per time point
}
\examples{
paras <- study_parameters(n1 = 11,
                          n2 = 10,
                          n3 = 6,
                          T_end = 10,
                          icc_pre_subject = 0.5,
                          icc_pre_cluster = 0,
                          icc_slope = 0.05,
                          var_ratio = 0.03)

get_sds(paras)

# plot
plot(get_sds(paras))

}
\seealso{
\code{\link{get_VPC}}, \code{\link{get_correlation_matrix}}
}
