% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reanalyse.powerNLSEM.R
\name{reanalyse.powerNLSEM}
\alias{reanalyse.powerNLSEM}
\title{Reanalyse powerNLSEM object}
\usage{
reanalyse.powerNLSEM(
  out,
  test = NULL,
  powerLevels = NULL,
  power_modeling_method = NULL,
  alpha = NULL,
  alpha_power_modeling = NULL
)
}
\arguments{
\item{out}{object of class powerNLSEM}

\item{test}{Should the parameter be tested with a directed hypothesis (onesided) or with an undirected hypothesis (twosided, also equivalent to Wald-Test for single parameter). Default to \code{NULL}, then the same as in fitted \code{powerNLSEM} object is used.}

\item{powerLevels}{Power levels for which the desired sample sizes should be computed. Needs to be a vector. Default to \code{NULL} indicating to use same power rate used in \code{powerNLSEM} object.}

\item{power_modeling_method}{Character indicating the power modeling method used. Default to \code{NULL}, indicating to use the same power modeling method as was used in the \code{powerNLSEM} object.}

\item{alpha}{Type I-error rate for significance decision. Default to \code{.05}.}

\item{alpha_power_modeling}{Type I-error rate for confidence band around predicted power rate. Used to ensure that the computed \code{N} keeps the desired power value (with the given Type I-error rate \code{alpha_power_modeling} divided by 2). If set to 1, no confidence band is used. Default to \code{.05}.}
}
\value{
Returns list of desired sample sizes per effect for each \code{powerLevel}. \code{Nall} refers to the sample size required per power level for all coefficients. \code{Npower} is a matrix containing the desired sample sizes per effect for every power level.
}
\description{
Reanalyse powerNLSEM object
}
