% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drpn.R, R/prpn.R, R/qrpn.R, R/rrpn.R
\name{revpn}
\alias{revpn}
\alias{drpn}
\alias{revpn}
\alias{prpn}
\alias{revpn}
\alias{qrpn}
\alias{revpn}
\alias{rrpn}
\title{The Reversal Power Normal Distribution}
\usage{
drpn(x, lambda, mu = 0, sigma = 1)

prpn(q, lambda, mu = 0, sigma = 1)

qrpn(p, lambda, mu = 0, sigma = 1)

rrpn(n, lambda, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the reversal power normal distribution with parameters mu, sigma and lambda.
}
\examples{
drpn(1, 1, 3, 4)
prpn(1, 1, 3, 4)
qrpn(0.2, 1, 3, 4)
rrpn(5, 2, 3, 4)
}
\references{
Anyosa, S. A. C. (2017) \emph{Binary regression using power and reversal power links}. Master's thesis in Portuguese. Interinstitutional Graduate Program in Statistics. Universidade de São Paulo - Universidade Federal de São Carlos. Available in \url{http://conteudo.icmc.usp.br/pessoas/jlbazan/download/thesis.pdf}.

Bazán, J. L., Torres -Avilés, F., Suzuki, A. K. and Louzada, F. (2017) Power and reversal power links for binary regressions: An application for motor insurance policyholders. \emph{Applied Stochastic Models in Business and Industry}, \strong{33}(1), 22-34.

Bazán, J. L., Romeo, J. S. and Rodrigues, J. (2014) Bayesian skew-probit regression for binary response data. \emph{Brazilian Journal of Probability and Statistics}. \strong{28}(4), 467–482.
}
