% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afps.R
\name{afps.powdRlib}
\alias{afps.powdRlib}
\title{Automated full pattern summation}
\usage{
\method{afps}{powdRlib}(lib, smpl, solver, obj, std, amorphous, tth_align,
  align, shift, tth_fps, background, lod, amorphous_lod, ...)
}
\arguments{
\item{lib}{A \code{powdRlib} object representing the reference library. Created using the
\code{powdRlib} constructor function.}

\item{smpl}{A data frame. First column is 2theta, second column is counts}

\item{solver}{The optimisation routine to be used. One of \code{c("BFGS", "Nelder-Mead",
"CG")}. Default = \code{"BFGS"}.}

\item{obj}{The objective function to minimise. One of \code{c("Delta", "R", "Rwp")}.
Default = \code{"Rwp"}. See Chipera and Bish (2002) and page 247 of Bish and Post (1989)
for definitions of these functions.}

\item{std}{The phase ID (e.g. "QUA.1") to be used as internal
standard. Must match an ID provided in the \code{phases} parameter.}

\item{amorphous}{A character string of any phase id's that should be treated as amorphous. Each must
match a phase_id in the phases table of `lib`.}

\item{tth_align}{A vector defining the minimum and maximum 2theta values to be used during
alignment. If not defined, then the full range is used.}

\item{align}{The maximum shift that is allowed during initial 2theta
alignment (degrees). Default = 0.1.}

\item{shift}{The maximum shift (degrees 2theta) that is allowed during the grid search phases selected
from the non-negative least squares. Default = 0.05).}

\item{tth_fps}{A vector defining the minimum and maximum 2theta values to be used during
automated full pattern summation. If not defined, then the full range is used.}

\item{background}{a list of parameters used to fit a background to the data. Takes the form
\code{list(lambda, hwi, it , int)}. If missing, the default used is
\code{list(lambda = 0.5, hwi = 25, it = 50, int = round(nrow(smpl)/4, 0)).} To tune these parameters
please see the \code{function}, or the background fitting tab of the \code{run_powdR} shiny app.}

\item{lod}{Optional parameter used to tune the lower limit of detection computation.
Must be greater than 0. Default = 0.3. Lower values represent lower detection limits.}

\item{amorphous_lod}{Optional parameter used to exclude amorphous phases if they are below this
specified limit (percent). Must be between 0 and 100. Default = 0.}

\item{...}{other arguments}
}
\value{
a list with components:
\item{tth}{a vector of the 2theta scale of the fitted data}
\item{fitted}{a vector of the fitted XRPD pattern}
\item{measured}{a vector of the original XRPD measurement (aligned)}
\item{background}{a vector of the fitted background used to estimate limits of detection}
\item{residuals}{a vector of the residuals (fitted vs measured)}
\item{phases}{a dataframe of the phases used to produce the fitted pattern}
\item{phases_summary}{the phases dataframe grouped by phase_name and summarised (sum)}
\item{rwp}{the Rwp of the fitted vs measured pattern}
\item{weighted_pure_patterns}{a dataframe of reference patterns used to produce the fitted pattern.
All patterns have been weighted according to the coefficients used in the fit}
\item{coefficients}{a named vector of coefficients used to produce the fitted pattern}
}
\description{
\code{afps.powdRlib} returns estimates of phase concentrations using automated full pattern
summation of X-ray powder diffraction data. It is designed for high-throughput cases
involving mineral quantification from large reference libraries.
}
\details{
Applies automated full pattern summation to an XRPD
sample to quantify phase concentrations. Requires a \code{powdRlib} library of reference
patterns with pre-measured reference intensity ratios in order to derive mineral
concentrations.
}
\examples{
#Load the minerals library
data(minerals)

# Load the soils data
data(soils)

#Since the reference library is relatively small,
#the whole library can be used at once to get an
#estimate of the phases within each sample.
\dontrun{
afps_sand <-  afps(lib = minerals,
                 smpl = soils$sandstone,
                 std = "QUA.1",
                 amorphous = "ORG",
                 align = 0.2)

afps_lime <- afps(lib = minerals,
                smpl = soils$limestone,
                std = "QUA.1",
                amorphous = "ORG",
                align = 0.2)

afps_granite <- afps(lib = minerals,
                   smpl = soils$granite,
                   std = "QUA.1",
                   amorphous = "ORG",
                   align = 0.2)
}
}
\references{
Bish, D.L., Post, J.E., 1989. Modern powder diffraction. Mineralogical Society of America.

Chipera, S.J., Bish, D.L., 2013. Fitting Full X-Ray Diffraction Patterns for Quantitative Analysis:
A Method for Readily Quantifying Crystalline and Disordered Phases. Adv. Mater. Phys. Chem. 03, 47-53.
doi:10.4236/ampc.2013.31A007

Chipera, S.J., Bish, D.L., 2002. FULLPAT: A full-pattern quantitative analysis program for X-ray powder
diffraction using measured and calculated patterns. J. Appl. Crystallogr. 35, 744-749.
doi:10.1107/S0021889802017405

Eberl, D.D., 2003. User's guide to ROCKJOCK - A program for determining quantitative mineralogy from
powder X-ray diffraction data. Boulder, CA.
}
