% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_dispatch.R
\name{rf_helper}
\alias{rf_helper}
\title{Helper function(randomforest).}
\usage{
rf_helper(X, Y, W, orthog.boost = FALSE, tree.n = 2000, tune = T,
  clustered = NULL)
}
\arguments{
\item{X}{A matrix of covariates (must be all numeric)}

\item{Y}{A vector of the target variable, of same length as the number of rows of Y, must be numeric}

\item{W}{A vector of the treatment variable, of same length as the number of rows of X, must be numeric}

\item{orthog.boost}{Whether to use orthogonal boosting, defaults to FALSE.}

\item{tree.n}{Controls the number of trees grown, defaults to 2000.}

\item{tune}{Whether to use hyperparameter tuning.}

\item{clustered}{Whether to use cluster robust forests, defaults to FALSE.}
}
\value{
A list with two elements: The fitted W model and the fitted Y model.
}
\description{
Helper function that dispatches to random forest (grf) for the post-double estimation.
}
\details{
If you need to use something that is not a default argument here, please refer to custom_generator. Not using honesty is heavily advised, though, as that could lead to a very high splitting, and the honesty is used for essentialy the same reason as crossfitting.
}
\examples{
\donttest{
  n = 2000; p = 10
  X = matrix(rnorm(n*p), n, p)
  W = rbinom(n, 1, 0.4 + 0.2 * (X[,1] > 0))
  Y = pmax(X[,1], 0) * W + X[,2] + pmin(X[,3], 0) + rnorm(n)



rf_helper( X = X, Y = Y, W = W, tree.n = 10)
}

}
