% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POSet.R
\name{POSet}
\alias{POSet}
\title{Constructing a Partially Ordered Set.}
\usage{
POSet(elements, dom = matrix(ncol = 2, nrow = 0))
}
\arguments{
\item{elements}{A vector of character strings (the labels of the elements of the ground set \eqn{V}).}

\item{dom}{Two-columns matrix of element labels, representing the dominances in the order relation
\eqn{\leq}. The generic \code{k-th} row of \code{dom} contains a pair of elements of \eqn{V}, with
\code{dom[k, 1] }\eqn{ \leq} \code{dom[k, 2]}.}
}
\value{
An object \eqn{(V, \leq)} of S4 class \code{POSet}, where \eqn{V} is the ground set and \eqn{\leq} is the partial order relation on it
}
\description{
Constructs an object of class \code{POSet}, representing a partially ordered set (poset) \eqn{P=(V,\leq)}.
}
\examples{
elems <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = dom)

}
