% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyInBetweenness.R
\name{FuzzyInBetweenness}
\alias{FuzzyInBetweenness}
\title{Fuzzy in-betweenness array computation}
\usage{
FuzzyInBetweenness(dom, norm, conorm, type, ...)
}
\arguments{
\item{dom}{square matrix representing the dominance degree between pairs of poset elements. Columns and rows names of \code{dom}
are interpreted as the labels of the poset elements. \code{dom} can be computed by using functions such as \code{BLSDominance},
\code{BubleyByesMRP} and \code{ExactMRP}.}

\item{norm}{R-function defining the t-norm}

\item{conorm}{R-function defining the t-conorm}

\item{type}{type of in-betweenness to be computed. Possible choices are:
"symmetric", "asymmetricLower", "asymmetricUpper".
For details on the definition of symmetric and asymmetric in-betweenness see Fattore et al. (2024).}

\item{...}{additional types of in-betweenness to be computed. Possible choices are:
"symmetric", "asymmetricLower", "asymmetricUpper".}
}
\value{
a list of three-dimensional arrays, one array for each type of in-betweenness selected by parameter \code{type}.
The array element of position \eqn{[i,j,k]} represents \eqn{finb_{p_i,p_j,p_k}} for symmetric in-betweenness,
\eqn{finb_{p_i<p_j<p_k}} for asymmetricLower in-betweenness, and \eqn{finb_{p_k<p_j<p_i}} for asymmetricUpper in-betweenness.
}
\description{
Starting from a poset dominance matrix, computes in-betweenness arrays by using a user supplied t-norm and t-conorm.
}
\examples{
el <- c("a", "b", "c", "d")

dom_list <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = el, dom = dom_list)

BLS <- BLSDominance(pos)

tnorm <- function(x,y){x*y}

tconorm <- function(x,y){x+y-x*y}

FinB <- FuzzyInBetweenness(BLS, norm=tnorm, conorm=tconorm, type="symmetric", "asymmetricLower")

}
\references{
Fattore, M., De Capitani, L., Avellone, A., and Suardi, A. (2024).
A fuzzy posetic toolbox for multi-criteria evaluation on ordinal data systems.
Annals of Operations Research, https://doi.org/10.1007/s10479-024-06352-3.
}
