% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.r
\docType{methods}
\name{bootgen2genind}
\alias{as.genclone}
\alias{as.genclone,genind-method}
\alias{bootgen2genind}
\alias{bootgen2genind,bootgen-method}
\alias{genclone2genind}
\alias{genclone2genind,genclone-method}
\title{Switch between genind and genclone objects.}
\usage{
bootgen2genind(bg)

as.genclone(x, ..., mlg, mlgclass = TRUE)

genclone2genind(x)
}
\arguments{
\item{bg}{a bootgen object}

\item{x}{a \code{\linkS4class{genind}} or \code{\linkS4class{genclone}} 
object}

\item{...}{arguments passed on to the \code{\linkS4class{genind}} constructor}

\item{mlg}{an optional vector of multilocus genotypes as integers}

\item{mlgclass}{should the mlg slot be of class MLG?}
}
\description{
as.genclone will create a genclone object from a genind object OR anything
that can be passed to the genind initializer.
}
\details{
genclone2genind will remove the mlg slot from the genclone object, creating a 
genind object.
}
\examples{
data(Aeut)
Aeut
Aeut.gc <- as.genclone(Aeut)
Aeut.gc
Aeut.gi <- genclone2genind(Aeut.gc)
Aeut.gi
data(nancycats)
nan.bg  <- new("bootgen", nancycats[pop = 9])
nan.bg
nan.gid <- bootgen2genind(nan.bg)
nan.gid
}
\author{
Zhian N. Kamvar
}
\seealso{
\code{\link{splitStrata}}, \code{\linkS4class{genclone}},
  \code{\link{read.genalex}}
  \code{\link{aboot}}
}

