% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bruvo.r
\name{test_replen}
\alias{test_replen}
\title{Test repeat length consistency.}
\usage{
test_replen(gid, replen)
}
\arguments{
\item{gid}{a genind object}

\item{replen}{a numeric vector of repeat motif lengths.}
}
\value{
a logical vector indicating whether or not the repeat motif length is
  consistent.
}
\description{
This function will test for consistency in the sense that all alleles are
able to be represented as discrete units after division and rounding.
}
\details{
This function is modified from the version used in
  \url{http://dx.doi.org/10.5281/zenodo.13007}.
}
\examples{
data(nancycats)
test_replen(nancycats, rep(2, 9))
}
\author{
Zhian N. Kamvar
}
\references{
Zhian N. Kamvar, Meg M. Larsen, Alan M. Kanaskie, Everett M.
  Hansen, & Niklaus J. Grünwald. Sudden_Oak_Death_in_Oregon_Forests: Spatial
  and temporal population dynamics of the sudden oak death epidemic in Oregon
  Forests. ZENODO, http://doi.org/10.5281/zenodo.13007, 2014.

  Kamvar, Z. N., Larsen, M. M., Kanaskie, A. M., Hansen, E. M., & Grünwald,
  N. J. (2015). Spatial and temporal analysis of populations of the sudden
  oak death pathogen in Oregon forests. Phytopathology XXX:X-X.
  \url{http://dx.doi.org/10.1094/PHYTO-12-14-0350-FI}

  Ruzica Bruvo, Nicolaas K. Michiels, Thomas G. D'Souza, and Hinrich
  Schulenburg. A simple method for the calculation of microsatellite genotype
  distances irrespective of ploidy level. Molecular Ecology, 13(7):2101-2106,
  2004.
}
\seealso{
\code{\link{fix_replen}} \code{\link{bruvo.dist}}
  \code{\link{bruvo.msn}} \code{\link{bruvo.boot}}
}

